/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.TypeTacheTO;
import org.jeinnov.jeitime.persistence.bo.projet.NomTacheP;
import org.jeinnov.jeitime.persistence.bo.projet.TypeTacheP;
import org.jeinnov.jeitime.persistence.dao.projet.NomTacheDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class NomTacheManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private NomTacheDAO nomTacheDAO = NomTacheDAO.getInstance();
    private static NomTacheManager manager;

    public static NomTacheManager getInstance() {
        if (manager == null) {
            manager = new NomTacheManager();
        }
        return manager;
    }

    public NomTacheTO get(int id) throws ProjetException {
        TypeTacheTO typeTacheTO;
        if (id == 0) {
            throw new ProjetException("Attention aucun nom de tache n'est s\u00e9lectionn\u00e9");
        }
        NomTacheTO nomTTO = new NomTacheTO();
        NomTacheP nomTP = new NomTacheP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            nomTP = (NomTacheP)this.nomTacheDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (nomTP != null) {
            nomTTO.setIdNomTache(nomTP.getIdNomTache());
            nomTTO.setNomTache(nomTP.getNomTache());
            typeTacheTO = new TypeTacheTO();
            TypeTacheP typeTacheP = nomTP.getTypeTache();
            if (typeTacheP != null) {
                typeTacheTO.setIdTypTach(typeTacheP.getIdTypeTache());
            }
        } else {
            throw new ProjetException("Attention aucun nom de tache avec cet identifiant existe dans la base !");
        }
        nomTTO.setTypeTache(typeTacheTO);
        return nomTTO;
    }

    public List<NomTacheTO> getAll() {
        ArrayList<NomTacheTO> listNomTTO = new ArrayList<NomTacheTO>();
        List listNomTP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listNomTP = this.nomTacheDAO.getAll();
            if (listNomTP != null) {
                for (NomTacheP nomTP : listNomTP) {
                    NomTacheTO nomTTO = new NomTacheTO();
                    nomTTO.setIdNomTache(nomTP.getIdNomTache());
                    nomTTO.setNomTache(nomTP.getNomTache());
                    TypeTacheTO typeTacheTO = new TypeTacheTO();
                    TypeTacheP typeTacheP = nomTP.getTypeTache();
                    if (typeTacheP != null) {
                        typeTacheTO.setIdTypTach(typeTacheP.getIdTypeTache());
                        typeTacheTO.setNomTypTach(typeTacheP.getNomTypeTache());
                    }
                    nomTTO.setTypeTache(typeTacheTO);
                    listNomTTO.add(nomTTO);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listNomTTO;
    }

    public List<NomTacheTO> getAllByIdTypeTache(int idTypeTache) throws ProjetException {
        if (idTypeTache == 0) {
            throw new ProjetException("Attention aucun groupe de tache n'est s\u00e9lectionn\u00e9");
        }
        ArrayList<NomTacheTO> listNomTTO = new ArrayList<NomTacheTO>();
        List listNomTP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listNomTP = this.nomTacheDAO.getAllByIdTypeTache(idTypeTache);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (listNomTP != null) {
            for (NomTacheP nomTP : listNomTP) {
                NomTacheTO nomTTO = new NomTacheTO();
                nomTTO.setIdNomTache(nomTP.getIdNomTache());
                nomTTO.setNomTache(nomTP.getNomTache());
                TypeTacheTO typeTacheTO = new TypeTacheTO();
                TypeTacheP typeTacheP = nomTP.getTypeTache();
                if (typeTacheP != null) {
                    typeTacheTO.setIdTypTach(typeTacheP.getIdTypeTache());
                }
                nomTTO.setTypeTache(typeTacheTO);
                listNomTTO.add(nomTTO);
            }
        }
        return listNomTTO;
    }

    public int saveOrUpdate(NomTacheTO nomTTO) throws ProjetException {
        if (nomTTO == null) {
            throw new ProjetException("Attention aucune t\u00e2che n'est cr\u00e9\u00e9");
        }
        if (nomTTO.getNomTache() == null) {
            throw new ProjetException("Attention aucun nom n'a \u00e9t\u00e9 donn\u00e9 \u00e0 la t\u00e2che");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        NomTacheP nomTP = new NomTacheP();
        nomTP = this.nomTacheDAO.getByName(nomTTO.getNomTache());
        this.verificationAvantEnregistrement(nomTTO, nomTP);
        if (nomTP == null || nomTP.getIdNomTache() == 0) {
            nomTP = new NomTacheP();
        }
        nomTP.setIdNomTache(nomTTO.getIdNomTache());
        nomTP.setNomTache(nomTTO.getNomTache());
        TypeTacheP typeTP = new TypeTacheP();
        TypeTacheTO typeTTO = nomTTO.getTypeTache();
        if (typeTTO != null) {
            typeTP.setIdTypeTache(typeTTO.getIdTypTach());
        }
        nomTP.setTypeTache(typeTP);
        try {
            this.nomTacheDAO.save((Object)nomTP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        int id = nomTP.getIdNomTache();
        return id;
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune t\u00e2che n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            NomTacheP nomTP = (NomTacheP)this.nomTacheDAO.find((Serializable)Integer.valueOf(id));
            if (nomTP == null || nomTP.getIdNomTache() == 0) {
                throw new ProjetException("Attention aucun nom de tache avec cet identifiant existe dans la base !");
            }
            this.nomTacheDAO.remove((Object)nomTP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInTache(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun nom de tache n'est s\u00e9lectionn\u00e9");
        }
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.nomTacheDAO.isInTache(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(NomTacheTO nomT, NomTacheP nomP) throws ProjetException {
        if (nomP != null && nomP.getIdNomTache() != nomT.getIdNomTache()) {
            throw new ProjetException("Attention, une t\u00e2che avec ce nom existe d\u00e9j\u00e0 !");
        }
        if (nomT.getTypeTache() == null) {
            throw new ProjetException("Attention aucun groupe de t\u00e2che n'est rattach\u00e9 \u00e0 cette t\u00e2che");
        }
    }
}

