/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ResultTransformersProject;
import org.jeinnov.jeitime.api.service.utils.SortList;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.persistence.bo.affecter.AffecterP;
import org.jeinnov.jeitime.persistence.bo.projet.ProjetP;
import org.jeinnov.jeitime.persistence.bo.projet.TacheP;
import org.jeinnov.jeitime.persistence.dao.affecter.AffecterDAO;
import org.jeinnov.jeitime.persistence.dao.projet.ProjetDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class ProjetManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ProjetDAO projetDAO = ProjetDAO.getInstance();
    private ResultTransformersProject resultTransformer = new ResultTransformersProject();
    private SortList sortList = new SortList();
    private static ProjetManager manager;

    public static ProjetManager getInstance() {
        if (manager == null) {
            manager = new ProjetManager();
        }
        return manager;
    }

    public ProjetTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        ProjetTO projet = new ProjetTO();
        ProjetP p = new ProjetP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            p = (ProjetP)this.projetDAO.find((Serializable)Integer.valueOf(id));
            if (p == null) {
                throw new ProjetException("Attention aucun projet avec cet id existe dans la base");
            }
            projet = this.resultTransformer.toProjectTO(p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return projet;
    }

    public ProjetTO getProjectNotLock(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        ProjetTO projet = new ProjetTO();
        ProjetP p = new ProjetP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            p = this.projetDAO.getProjectNotLock(id);
            if (p == null) {
                throw new ProjetException("Attention aucun projet avec cet id existe dans la base");
            }
            projet = this.resultTransformer.toProjectTO(p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return projet;
    }

    public ProjetTO getProjectNotClose(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        ProjetTO projet = new ProjetTO();
        ProjetP p = new ProjetP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            p = this.projetDAO.getProjectNotLockNotClose(id);
            if (p == null) {
                throw new ProjetException("Attention aucun projet avec cet id existe dans la base");
            }
            projet = this.resultTransformer.toProjectTO(p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return projet;
    }

    public List<ProjetTO> getAll() {
        ArrayList<ProjetTO> listProjetTO = new ArrayList<ProjetTO>();
        List listProjetP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listProjetP = this.projetDAO.findAll();
            if (listProjetP != null) {
                for (ProjetP p : listProjetP) {
                    ProjetTO projet = this.resultTransformer.toProjectTO(p);
                    listProjetTO.add(projet);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Collections.sort(listProjetTO);
        return listProjetTO;
    }

    public List<ProjetTO> getAllNotLock() {
        ArrayList<ProjetTO> listProjetTO = new ArrayList<ProjetTO>();
        List listProjetP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listProjetP = this.projetDAO.getAllNotLock();
            if (listProjetP != null) {
                for (ProjetP p : listProjetP) {
                    ProjetTO projet = this.resultTransformer.toProjectTO(p);
                    listProjetTO.add(projet);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listProjetTO;
    }

    public List<ProjetTO> getAllLock() {
        ArrayList<ProjetTO> listProjetTO = new ArrayList<ProjetTO>();
        List listProjetP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listProjetP = this.projetDAO.getAllLock();
            if (listProjetP != null) {
                for (ProjetP p : listProjetP) {
                    ProjetTO projet = this.resultTransformer.toProjectTO(p);
                    listProjetTO.add(projet);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listProjetTO;
    }

    public List<ProjetTO> getAllNotClose() {
        ArrayList<ProjetTO> listProjetTO = new ArrayList<ProjetTO>();
        List listProjetP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listProjetP = this.projetDAO.getAllNotClose();
            if (listProjetP != null) {
                for (ProjetP p : listProjetP) {
                    ProjetTO projet = this.resultTransformer.toProjectTO(p);
                    listProjetTO.add(projet);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listProjetTO;
    }

    public List<ProjetTO> getAllClose() {
        ArrayList<ProjetTO> listProjetTO = new ArrayList<ProjetTO>();
        List listProjetP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listProjetP = this.projetDAO.getAllClose();
            if (listProjetP != null) {
                for (ProjetP p : listProjetP) {
                    ProjetTO projet = this.resultTransformer.toProjectTO(p);
                    listProjetTO.add(projet);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listProjetTO;
    }

    public List<ProjetTO> getAllForCollabNotLock(int idColl) throws ProjetException {
        if (idColl == 0) {
            throw new ProjetException("Attention aucun collaborateur avec cet id existe dans la base");
        }
        ArrayList<ProjetTO> tablProjet = new ArrayList<ProjetTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listA = AffecterDAO.getInstance().getAllByCollabIdAndNotDissociate(idColl);
            List<TacheP> listT = new ArrayList();
            if (listA != null) {
                for (AffecterP a : listA) {
                    TacheP tacheP = a.getTache();
                    listT.add(tacheP);
                }
            }
            listT = this.sortList.sortListTachePProjetNotLock(listT);
            for (TacheP t : listT) {
                ProjetTO pTO = new ProjetTO();
                pTO.setIdProjet(t.getProjet().getIdProjet());
                pTO.setNomProjet(t.getProjet().getNomProjet());
                tablProjet.add(pTO);
            }
            Collections.sort(tablProjet);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return tablProjet;
    }

    public List<ProjetTO> getAllForCollabNotClose(int idColl) throws ProjetException {
        if (idColl == 0) {
            throw new ProjetException("Attention aucun collaborateur avec cet id existe dans la base");
        }
        ArrayList<ProjetTO> tablProjet = new ArrayList<ProjetTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listA = AffecterDAO.getInstance().getAllByCollabIdAndNotDissociate(idColl);
            List<TacheP> listT = new ArrayList();
            if (listA != null) {
                for (AffecterP a : listA) {
                    TacheP tacheP = a.getTache();
                    listT.add(tacheP);
                }
            }
            listT = this.sortList.sortListTachePProjetNotClose(listT);
            for (TacheP t : listT) {
                ProjetTO pTO = new ProjetTO();
                pTO.setIdProjet(t.getProjet().getIdProjet());
                pTO.setNomProjet(t.getProjet().getNomProjet());
                tablProjet.add(pTO);
            }
            Collections.sort(tablProjet);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return tablProjet;
    }

    public int saveOrUpdate(ProjetTO projet) throws ProjetException {
        int idProjet;
        if (projet == null) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        if (projet.getNomProjet() == null) {
            throw new ProjetException("Attention aucun nom n'a \u00e9t\u00e9 donn\u00e9 au projet ");
        }
        ProjetP p = new ProjetP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            p = this.projetDAO.getByName(projet.getNomProjet());
            this.verificationAvantEnregistrement(projet, p);
            if (p == null || p.getIdProjet() == 0) {
                p = new ProjetP();
            }
            this.resultTransformer.toProjectP(projet, p);
            this.projetDAO.save((Object)p);
            idProjet = p.getIdProjet();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return idProjet;
    }

    public void closeProject(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ProjetP p = (ProjetP)this.projetDAO.find((Serializable)Integer.valueOf(id));
            if (p == null) {
                throw new ProjetException("Attention, le projet s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            p.setDateFermeture(new Date());
            this.projetDAO.save((Object)p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void openProject(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ProjetP p = (ProjetP)this.projetDAO.find((Serializable)Integer.valueOf(id));
            if (p == null) {
                throw new ProjetException("Attention, le projet s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            p.setDateFermeture(null);
            this.projetDAO.save((Object)p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void lockProject(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ProjetP p = (ProjetP)this.projetDAO.find((Serializable)Integer.valueOf(id));
            if (p == null) {
                throw new ProjetException("Attention, le projet s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            p.setDateCloture(new Date());
            if (p.getDateFermeture() == null) {
                p.setDateFermeture(new Date());
            }
            this.projetDAO.save((Object)p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ProjetP p = (ProjetP)this.projetDAO.find((Serializable)Integer.valueOf(id));
            if (p == null || p.getIdProjet() == 0) {
                throw new ProjetException("Attention, le projet s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            this.verifSiProjetRattache(p);
            this.projetDAO.remove((Object)p);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void verifSiProjetRattache(ProjetP projet) {
        List listP = this.projetDAO.getBySousProjet(projet);
        if (listP != null && !listP.isEmpty()) {
            for (int i = 0; i < listP.size(); ++i) {
                ((ProjetP)listP.get(i)).setProjet(null);
                this.projetDAO.save(listP.get(i));
            }
        }
    }

    public boolean isInLienTachUtil(int id) {
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.projetDAO.verifLien(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(ProjetTO pTO, ProjetP pP) throws ProjetException {
        if (pTO.getTypeProjet() == null) {
            throw new ProjetException("Attention aucun type de projet n'est rattach\u00e9 au projet");
        }
        if (pP != null && pP.getIdProjet() != pTO.getIdProjet()) {
            throw new ProjetException("Attention, un projet avec ce nom existe d\u00e9j\u00e0 !");
        }
    }
}

