/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ResultTransformersProject;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.persistence.bo.affecter.AffecterP;
import org.jeinnov.jeitime.persistence.bo.projet.NomTacheP;
import org.jeinnov.jeitime.persistence.bo.projet.ProjetP;
import org.jeinnov.jeitime.persistence.bo.projet.TacheP;
import org.jeinnov.jeitime.persistence.dao.affecter.AffecterDAO;
import org.jeinnov.jeitime.persistence.dao.projet.TacheDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class TacheManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private TacheDAO tacheDAO = TacheDAO.getInstance();
    private ResultTransformersProject resultTransformer = new ResultTransformersProject();
    private static TacheManager manager;

    public static TacheManager getInstance() {
        if (manager == null) {
            manager = new TacheManager();
        }
        return manager;
    }

    public TacheTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune t\u00e2che n'est s\u00e9lectionn\u00e9");
        }
        TacheTO tacheTO = new TacheTO();
        TacheP tacheP = new TacheP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            tacheP = (TacheP)this.tacheDAO.find((Serializable)Integer.valueOf(id));
            if (tacheP == null) {
                throw new ProjetException("Attention aucune t\u00e2che avec cet identifiant existe dans la base !");
            }
            tacheTO = this.resultTransformer.toTacheTO(tacheP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return tacheTO;
    }

    public List<TacheTO> getAllTacheInProject(int idProjet) throws ProjetException {
        if (idProjet == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        ArrayList<TacheTO> listTacheTO = new ArrayList<TacheTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listTacheP = this.tacheDAO.getAllTacheInProject(idProjet);
            if (listTacheP != null) {
                for (TacheP tacheP : listTacheP) {
                    TacheTO tacheTO = this.resultTransformer.toTacheTO(tacheP);
                    listTacheTO.add(tacheTO);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Collections.sort(listTacheTO);
        return listTacheTO;
    }

    public List<TacheTO> getAllInProjectAndForACollaborateur(int idProjet, int idCollaborateur) throws ProjetException {
        if (idProjet == 0) {
            throw new ProjetException("Attention aucun projet n'est s\u00e9lectionn\u00e9");
        }
        if (idCollaborateur == 0) {
            throw new ProjetException("Attention aucun collaborateur n'est s\u00e9lectionn\u00e9");
        }
        ArrayList<TacheTO> listTacheTO = new ArrayList<TacheTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listTacheP = this.tacheDAO.getAllTacheInProject(idProjet);
            if (listTacheP != null) {
                for (TacheP tacheP : listTacheP) {
                    AffecterP affecter = AffecterDAO.getInstance().getAllByIdCollaborateurAndIdTacheAndNotDissociate(idCollaborateur, tacheP.getIdTache());
                    if (affecter == null) continue;
                    TacheTO tacheTO = this.resultTransformer.toTacheTO(tacheP);
                    listTacheTO.add(tacheTO);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Collections.sort(listTacheTO);
        return listTacheTO;
    }

    public int saveOrUpdate(TacheTO tacheTO) throws ProjetException {
        TacheP tacheP = new TacheP();
        if (tacheTO == null) {
            throw new ProjetException("Attention aucune t\u00e2che n'a \u00e9t\u00e9 cr\u00e9\u00e9e");
        }
        if (tacheTO.getProjet() == null) {
            throw new ProjetException("Vous devez sp\u00e9cifier un projet");
        }
        if (tacheTO.getNomtache() == null) {
            throw new ProjetException("Vous devez sp\u00e9cifier une t\u00e2che");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        ProjetP projetP = new ProjetP(tacheTO.getProjet().getIdProjet());
        NomTacheP nomTacheP = new NomTacheP();
        nomTacheP.setIdNomTache(tacheTO.getNomtache().getIdNomTache());
        try {
            tacheP = this.tacheDAO.getByProjetAndNomTache(projetP, nomTacheP);
            this.verificationAvantEnregistrement(tacheTO, tacheP);
            if (tacheP == null || tacheP.getIdTache() == 0) {
                tacheP = new TacheP();
            }
            this.resultTransformer.toTacheP(tacheTO, tacheP);
            this.tacheDAO.save((Object)tacheP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return tacheP.getIdTache();
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune t\u00e2che n'est s\u00e9lectionn\u00e9e");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            TacheP tacheP = (TacheP)this.tacheDAO.find((Serializable)Integer.valueOf(id));
            if (tacheP == null || tacheP.getIdTache() == 0) {
                throw new ProjetException("Attention, la t\u00e2che s\u00e9lectionn\u00e9e n'existe pas dans la base.");
            }
            this.tacheDAO.remove((Object)tacheP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteAllTacheInProject(int idProjet) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listTacheP = this.tacheDAO.getAllTacheInProject(idProjet);
            if (listTacheP != null) {
                for (TacheP tacheP : listTacheP) {
                    List listAffecter = AffecterDAO.getInstance().getAllByIdTache(tacheP.getIdTache());
                    for (AffecterP af : listAffecter) {
                        AffecterDAO.getInstance().remove((Object)af);
                    }
                    this.tacheDAO.remove((Object)tacheP);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInLienTachUtil(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune t\u00e2che n'est s\u00e9lectionn\u00e9");
        }
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.tacheDAO.isInLienTachUtil(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(TacheTO tTO, TacheP tP) throws ProjetException {
        if (tP != null && tP.getIdTache() != tTO.getIdTache()) {
            throw new ProjetException("Attention, une m\u00eame t\u00e2che existe d\u00e9j\u00e0 pour ce projet !");
        }
    }
}

