/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.ThematiqueTO;
import org.jeinnov.jeitime.persistence.bo.projet.ThematiqueP;
import org.jeinnov.jeitime.persistence.dao.projet.ThematiqueDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class ThematiqueManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ThematiqueDAO thematiqueDAO = ThematiqueDAO.getInstance();
    private static ThematiqueManager manager;

    public static ThematiqueManager getInstance() {
        if (manager == null) {
            manager = new ThematiqueManager();
        }
        return manager;
    }

    public ThematiqueTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune th\u00e9matique n'est s\u00e9lectionn\u00e9e");
        }
        ThematiqueTO themTO = new ThematiqueTO();
        ThematiqueP themP = new ThematiqueP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            themP = (ThematiqueP)this.thematiqueDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (themP == null) {
            throw new ProjetException("Attention aucune Th\u00e9matique existe avec cet identifiant dans la base.");
        }
        themTO.setIdThema(themP.getIdThematique());
        themTO.setNomThema(themP.getNomThematique());
        return themTO;
    }

    public List<ThematiqueTO> getAll() {
        ArrayList<ThematiqueTO> listThemTO = new ArrayList<ThematiqueTO>();
        List listThemP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listThemP = this.thematiqueDAO.getAll();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (listThemP != null) {
            for (ThematiqueP themP : listThemP) {
                ThematiqueTO them = new ThematiqueTO();
                them.setIdThema(themP.getIdThematique());
                them.setNomThema(themP.getNomThematique());
                listThemTO.add(them);
            }
        }
        return listThemTO;
    }

    public int saveOrUpdate(ThematiqueTO themTO) throws ProjetException {
        if (themTO == null) {
            throw new ProjetException("Attention aucune th\u00e9matique n'est s\u00e9lectionn\u00e9e");
        }
        if (themTO.getNomThema() == null) {
            throw new ProjetException("Attention vous devez sp\u00e9cifier un nom \u00e0 la nouvelle th\u00e9matique !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        ThematiqueP themP = new ThematiqueP();
        try {
            themP = this.thematiqueDAO.getByName(themTO.getNomThema());
            this.verificationAvantEnregistrement(themTO, themP);
            if (themP == null || themP.getIdThematique() == 0) {
                themP = new ThematiqueP();
            }
            themP.setIdThematique(themTO.getIdThema());
            themP.setNomThematique(themTO.getNomThema());
            this.thematiqueDAO.save((Object)themP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        int id = themP.getIdThematique();
        return id;
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune th\u00e9matique n'est s\u00e9lectionn\u00e9e");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ThematiqueP themP = (ThematiqueP)this.thematiqueDAO.find((Serializable)Integer.valueOf(id));
            if (themP == null || themP.getIdThematique() == 0) {
                throw new ProjetException("Attention aucune Th\u00e9matique existe avec cet identifiant dans la base.");
            }
            this.thematiqueDAO.remove((Object)themP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInProject(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucune th\u00e9matique n'est s\u00e9lectionn\u00e9e");
        }
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.thematiqueDAO.isInProject(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(ThematiqueTO themT, ThematiqueP themP) throws ProjetException {
        if (themP != null) {
            if (themT.getIdThema() == 0) {
                throw new ProjetException("Attention, une th\u00e9matique avec ce nom existe d\u00e9j\u00e0 !");
            }
            if (themP.getIdThematique() != themT.getIdThema()) {
                throw new ProjetException("Attention,une th\u00e9matique avec ce nom existe d\u00e9j\u00e0 !");
            }
        }
    }
}

