/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.TypeProjetTO;
import org.jeinnov.jeitime.persistence.bo.projet.TypeProjetP;
import org.jeinnov.jeitime.persistence.dao.projet.TypeProjetDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class TypeProjetManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private TypeProjetDAO typeProjetDAO = TypeProjetDAO.getInstance();
    private static TypeProjetManager manager;

    public static TypeProjetManager getInstance() {
        if (manager == null) {
            manager = new TypeProjetManager();
        }
        return manager;
    }

    public TypeProjetTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun Type de Projet n'est s\u00e9lectionn\u00e9.");
        }
        TypeProjetTO typePTO = new TypeProjetTO();
        TypeProjetP typePP = new TypeProjetP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            typePP = (TypeProjetP)this.typeProjetDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (typePP == null) {
            throw new ProjetException("Attention aucun Type de Projet existe avec cet identifiant dans la base.");
        }
        typePTO.setIdTypeProj(typePP.getIdTypePro());
        typePTO.setNomTypePro(typePP.getNomTypePro());
        return typePTO;
    }

    public List<TypeProjetTO> getAll() {
        ArrayList<TypeProjetTO> listTypePTO = new ArrayList<TypeProjetTO>();
        List listTypePP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listTypePP = this.typeProjetDAO.getAll();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (listTypePP != null) {
            for (TypeProjetP tPP : listTypePP) {
                TypeProjetTO tPTO = new TypeProjetTO();
                tPTO.setIdTypeProj(tPP.getIdTypePro());
                tPTO.setNomTypePro(tPP.getNomTypePro());
                listTypePTO.add(tPTO);
            }
        }
        return listTypePTO;
    }

    public int saveOrUpdate(TypeProjetTO tPTO) throws ProjetException {
        if (tPTO == null) {
            throw new ProjetException("Attention aucun type de projet n'est s\u00e9lectionn\u00e9");
        }
        if (tPTO.getNomTypePro() == null) {
            throw new ProjetException("Attention aucun nom n'a \u00e9t\u00e9 donn\u00e9 au type de projet ");
        }
        TypeProjetP typePP = new TypeProjetP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            typePP = this.typeProjetDAO.getByName(tPTO.getNomTypePro());
            this.verificationAvantEnregistrement(tPTO, typePP);
            if (typePP == null || typePP.getIdTypePro() == 0) {
                typePP = new TypeProjetP();
            }
            typePP.setIdTypePro(tPTO.getIdTypeProj());
            typePP.setNomTypePro(tPTO.getNomTypePro());
            this.typeProjetDAO.save((Object)typePP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        int id = typePP.getIdTypePro();
        return id;
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun type de projet n'est s\u00e9lectionn\u00e9");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            TypeProjetP typePP = (TypeProjetP)this.typeProjetDAO.find((Serializable)Integer.valueOf(id));
            if (typePP == null || typePP.getIdTypePro() == 0) {
                throw new ProjetException("Attention aucun Type de Projet existe avec cet identifiant dans la base.");
            }
            if (typePP.getProjets() != null && !typePP.getProjets().isEmpty()) {
                throw new ProjetException("Attention ce Type de projet ne pourra \u00eatre supprim\u00e9, car des projets lui sont rattach\u00e9s.");
            }
            this.typeProjetDAO.remove((Object)typePP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInProjet(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun Type de Projet n'est s\u00e9lectionn\u00e9.");
        }
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.typeProjetDAO.isInProject(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(TypeProjetTO typePT, TypeProjetP typePP) throws ProjetException {
        if (typePP != null && typePP.getIdTypePro() != typePT.getIdTypeProj()) {
            throw new ProjetException("Attention,un type de projet avec ce nom existe d\u00e9j\u00e0 !");
        }
    }
}

