/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.affecter;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.affecter.AffecterException;
import org.jeinnov.jeitime.api.service.affecter.AffecterManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.collaborateur.EquipeManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.service.projet.TacheManager;
import org.jeinnov.jeitime.api.to.affecter.RecapAffectTO;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.collaborateur.EquipeTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class AffecterUIBean {
    private AffecterManager affecterManager = AffecterManager.getInstance();
    private int idProjet;
    private List<ProjetTO> allprojet;
    private int idTache;
    private List<TacheTO> alltache;
    private int[] selectedTache;
    private int idColl;
    private List<CollaborateurTO> allCollabEquip;
    private int[] selectedColl;
    private int idEq;
    private List<EquipeTO> allequipe;
    private List<RecapAffectTO> allAffect;
    private List<RecapAffectTO> listRecapAffect;
    private List<String> listSupprAffect;
    private int suivant = 0;
    private boolean voirTache;
    private boolean voirCollab;
    private boolean voirRecap;

    public void loadAllProjets() throws IError {
        this.allprojet = ProjetManager.getInstance().getAllNotLock();
        if (this.allprojet == null || this.allprojet.isEmpty()) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Pour pouvoir effectuer les affectations des ressources vous devez au pr\u00e9alable cr\u00e9er au moins un projet avec ses t\u00e2ches");
            error.setType((short)0);
            throw error;
        }
    }

    public void loadAllTache(HttpServletRequest iRequest) throws IError {
        if (iRequest.getParameter("id") != null && !iRequest.getParameter("id").equalsIgnoreCase("0")) {
            this.idProjet = Integer.parseInt(iRequest.getParameter("id"));
        }
        try {
            this.alltache = TacheManager.getInstance().getAllTacheInProject(this.idProjet);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le projet avec l'id " + this.idProjet + "n'existe pas. ", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.voirTache = true;
        this.voirCollab = false;
        this.voirRecap = false;
    }

    public void loadAllEquipe() {
        this.allequipe = new ArrayList();
        this.idEq = 0;
        EquipeTO aucuneEqu = new EquipeTO();
        aucuneEqu.setIdEquip(0);
        aucuneEqu.setNomEquip("--S\u00e9lectionnez une Equipe--");
        EquipeTO tousCollabs = new EquipeTO();
        tousCollabs.setIdEquip(9999);
        tousCollabs.setNomEquip("--Tous les Collaborateurs--");
        this.allequipe = EquipeManager.getInstance().getAll();
        this.allequipe.add(0, aucuneEqu);
        this.allequipe.add(1, tousCollabs);
        this.voirTache = false;
        this.voirCollab = true;
        this.voirRecap = false;
    }

    public void loadAllAffectation(HttpServletRequest iRequest) throws IError {
        this.idProjet = Integer.parseInt(iRequest.getParameter("id"));
        try {
            this.allAffect = this.affecterManager.getAllByIdProjet(this.idProjet);
        }
        catch (AffecterException e) {
            NonLocalizedError error = new NonLocalizedError("Une erreur est survenue, Le projet avec l'id " + this.idProjet + "n'existe pas.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public void create(List<RecapAffectTO> listRecapAffect) throws IError {
        try {
            this.affecterManager.saveAll(listRecapAffect);
        }
        catch (AffecterException e) {
            NonLocalizedError error = new NonLocalizedError("Une erreur est survenue, l'enregistrement des affectations est impossible", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.loadAllEquipe();
        this.loadAllProjets();
        this.reset();
    }

    public void supprAffect() throws IError {
        for (String rA : this.listSupprAffect) {
            String[] params = rA.split(";");
            for (int i = 0; i < params.length; ++i) {
                if (i == 0) {
                    this.idColl = Integer.valueOf(params[0]);
                }
                if (i != 1) continue;
                this.idTache = Integer.valueOf(params[1]);
            }
            try {
                this.affecterManager.delete(this.idTache, this.idColl);
            }
            catch (AffecterException e) {
                NonLocalizedError error = new NonLocalizedError("Une erreur est survenue, la suppression de l'affectation n'a pas pu \u00eatre effectu\u00e9e.Le collaborateur avec l'id " + this.idColl + "n'est peut \u00eatre pas associ\u00e9 \u00e0 la tache avec l'id " + this.idTache, e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            this.allAffect = new ArrayList();
            try {
                this.allAffect = this.affecterManager.getAllByIdProjet(this.idProjet);
            }
            catch (AffecterException e) {
                NonLocalizedError error = new NonLocalizedError("Une erreur est survenue, la liste des affectations n'a pas pu \u00eatre charg\u00e9e. Le projet avec l'id " + this.idProjet + "n'existe pas.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
        }
    }

    public void selectCollaborateur(int idEq) {
        this.allCollabEquip = idEq == 0 ? null : (idEq == 9999 ? CollaborateurManager.getInstance().getAllWithoutAdmin() : CollaborateurManager.getInstance().getAllByIdEquipe(idEq));
    }

    public void selectAllTache() {
        this.selectedTache = new int[this.alltache.size()];
        for (int i = 0; i < this.alltache.size(); ++i) {
            this.selectedTache[i] = ((TacheTO)this.alltache.get(i)).getIdTache();
        }
    }

    public void deSelectAllTache() {
        this.selectedTache = null;
    }

    public void selectAllColl(int idEq) {
        this.selectedColl = new int[this.allCollabEquip.size()];
        for (int i = 0; i < this.allCollabEquip.size(); ++i) {
            this.selectedColl[i] = ((CollaborateurTO)this.allCollabEquip.get(i)).getIdColl();
        }
    }

    public void deSelectAllColl() {
        this.selectedColl = null;
    }

    public void deselectColl(HttpServletRequest iRequest) {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        for (int i = 0; i < this.listRecapAffect.size(); ++i) {
            if (((RecapAffectTO)this.listRecapAffect.get(i)).getCollaborateur().getIdColl() != id) continue;
            this.listRecapAffect.remove(i);
            break;
        }
    }

    public void voirTableauRecap() throws ProjetException, CollaborateurException {
        ArrayList<TacheTO> soustaches = new ArrayList<TacheTO>();
        ArrayList<CollaborateurTO> souscollaborateurs = new ArrayList<CollaborateurTO>();
        CollaborateurManager collaborateurManager = CollaborateurManager.getInstance();
        TacheManager tacheManager = TacheManager.getInstance();
        this.listRecapAffect = new ArrayList();
        for (int id : this.selectedTache) {
            TacheTO t = tacheManager.get(id);
            soustaches.add(t);
        }
        for (int id : this.selectedColl) {
            CollaborateurTO c = collaborateurManager.get(id);
            souscollaborateurs.add(c);
        }
        for (CollaborateurTO c : souscollaborateurs) {
            for (TacheTO t : soustaches) {
                RecapAffectTO recap = new RecapAffectTO();
                recap.setTache(t);
                recap.setCollaborateur(c);
                this.listRecapAffect.add(recap);
            }
        }
        this.voirTache = false;
        this.voirCollab = false;
        this.voirRecap = true;
    }

    public void reset() {
        this.selectedTache = null;
        this.selectedColl = null;
        this.allAffect = new ArrayList();
    }

    public List<ProjetTO> getAllprojet() {
        return this.allprojet;
    }

    public void setAllprojet(List<ProjetTO> allprojet) {
        this.allprojet = allprojet;
    }

    public List<TacheTO> getAlltache() {
        return this.alltache;
    }

    public void setAlltache(List<TacheTO> alltache) {
        this.alltache = alltache;
    }

    public int getIdProjet() {
        return this.idProjet;
    }

    public void setIdProjet(int idProjet) {
        this.idProjet = idProjet;
    }

    public int getSuivant() {
        return this.suivant;
    }

    public void setSuivant(int suivant) {
        this.suivant = suivant;
    }

    public int[] getSelectedTache() {
        return this.selectedTache;
    }

    public void setSelectedTache(int[] selectedTache) {
        this.selectedTache = selectedTache;
    }

    public int[] getSelectedColl() {
        return this.selectedColl;
    }

    public void setSelectedColl(int[] selectedColl) {
        this.selectedColl = selectedColl;
    }

    public List<CollaborateurTO> getAllCollabEquip() {
        return this.allCollabEquip;
    }

    public void setAllCollabEquip(List<CollaborateurTO> allCollabEquip) {
        this.allCollabEquip = allCollabEquip;
    }

    public List<RecapAffectTO> getAllAffect() {
        return this.allAffect;
    }

    public void setAllAffect(List<RecapAffectTO> allAffect) {
        this.allAffect = allAffect;
    }

    public int getIdEq() {
        return this.idEq;
    }

    public void setIdEq(int idEq) {
        this.idEq = idEq;
    }

    public List<EquipeTO> getAllequipe() {
        return this.allequipe;
    }

    public List<RecapAffectTO> getListRecapAffect() {
        return this.listRecapAffect;
    }

    public void setListRecapAffect(List<RecapAffectTO> listRecapAffect) {
        this.listRecapAffect = listRecapAffect;
    }

    public int getIdTache() {
        return this.idTache;
    }

    public void setIdTache(int idTache) {
        this.idTache = idTache;
    }

    public int getIdColl() {
        return this.idColl;
    }

    public void setIdColl(int idColl) {
        this.idColl = idColl;
    }

    public List<String> getListSupprAffect() {
        return this.listSupprAffect;
    }

    public void setListSupprAffect(List<String> listSupprAffect) {
        this.listSupprAffect = listSupprAffect;
    }

    public boolean isVoirTache() {
        return this.voirTache;
    }

    public void setVoirTache(boolean voirTache) {
        this.voirTache = voirTache;
    }

    public boolean isVoirCollab() {
        return this.voirCollab;
    }

    public void setVoirCollab(boolean voirCollab) {
        this.voirCollab = voirCollab;
    }

    public boolean isVoirRecap() {
        return this.voirRecap;
    }

    public void setVoirRecap(boolean voirRecap) {
        this.voirRecap = voirRecap;
    }
}

