/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.bilan;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.bilan.DomaineBilanManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.projet.DomaineManager;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetTO;
import org.jeinnov.jeitime.api.to.bilan.SousTotal;
import org.jeinnov.jeitime.api.to.bilan.Total;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.DomaineTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class RecapDomUIBean {
    private Date dateDeb;
    private String dateD;
    private Date dateFin;
    private String dateF;
    private DomaineBilanManager domaineBilanManager = DomaineBilanManager.getInstance();
    private int[] selectedDom;
    private List<DomaineTO> allDomaine = new ArrayList();
    private List<CollaborateurTO> collaborateurs = new ArrayList();
    private List<Object> items = new ArrayList();
    private List<RecapProjetTO> listRecap = new ArrayList();
    private boolean voirTabl = false;
    private boolean voirDom;
    private boolean voirDate;

    public void load() {
        this.allDomaine = DomaineManager.getInstance().getAll();
        this.voirDate = true;
    }

    public void envoyer() {
        this.voirTabl = false;
        this.voirDom = true;
    }

    public void reset() {
        this.voirDate = true;
        this.voirTabl = false;
        this.voirDom = true;
        this.selectedDom = null;
    }

    public void voirTableauDomaine() throws IError {
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        this.dateD = dateFormat.format(this.dateDeb);
        this.dateF = dateFormat.format(this.dateFin);
        this.collaborateurs = CollaborateurManager.getInstance().getAll();
        this.items = new ArrayList();
        try {
            this.items = this.domaineBilanManager.listTacheDomaine(this.selectedDom);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun domaine n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.listRecap = this.domaineBilanManager.creerListRecapProjetDomaine(this.selectedDom, this.dateDeb, this.dateFin);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun domaine n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.voirTabl = true;
        this.voirDom = false;
        this.voirDate = false;
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=titleTable>" + item + "</span>";
        }
        if (item instanceof Integer) {
            return "Total du Domaine";
        }
        if (item instanceof ProjetTO) {
            return "\\html\\<span class=sousTitleTable>" + ((ProjetTO)item).getNomProjet() + "</span>";
        }
        if (item instanceof SousTotal) {
            return ((SousTotal)item).getNomSousTotal();
        }
        if (item instanceof Total) {
            return "Total du Projet";
        }
        return ((TacheTO)item).getNomtache().getNomTache();
    }

    public String getValue(Object item, CollaborateurTO collab) {
        if (item instanceof String) {
            return null;
        }
        if (item instanceof ProjetTO) {
            return null;
        }
        if (item instanceof Integer) {
            return this.itemsInstanceOfInteger(item, collab);
        }
        if (item instanceof SousTotal) {
            return this.itemsInstanceOfSousTotal(item, collab);
        }
        if (item instanceof Total) {
            return this.itemsInstanceOfTotal(item, collab);
        }
        return this.itemsInstanceOfTacheTO(item, collab);
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (this.dateDeb != null && this.dateFin != null && this.dateFin.before(this.dateDeb)) {
            errors.addItemError("recapBeanDom.dateFin", (ValidationError)new LocalizedValidationError("validation.date"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    private String itemsInstanceOfInteger(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = (Integer)item;
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getDomaine().getIdDomaine() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfSousTotal(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTotal(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = ((Total)item).getIdProjet();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTacheTO(Object item, CollaborateurTO collab) {
        int idT = ((TacheTO)item).getIdTache();
        int idCo = collab.getIdColl();
        String nb = "";
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache() || idCo != ((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl()) continue;
            double nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        if (item instanceof String) {
            return null;
        }
        if (item instanceof ProjetTO) {
            return null;
        }
        if (item instanceof Integer) {
            return this.totalInstanceOfInteger(item, nbh);
        }
        if (item instanceof SousTotal) {
            return this.totalInstanceOfSousTotal(item);
        }
        if (item instanceof Total) {
            return this.totalInstanceOfTotal(item);
        }
        return this.totalInstanceOfTacheTO(item, nbh);
    }

    private String totalInstanceOfInteger(Object item, double nbh) {
        for (int i = 0; i < this.listRecap.size(); ++i) {
            int idP = (Integer)item;
            if (idP != ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getDomaine().getIdDomaine()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        return df.format(nbh);
    }

    private String totalInstanceOfSousTotal(Object item) {
        String totalTmp = null;
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            totalTmp = df.format(nbht);
        }
        return totalTmp;
    }

    private String totalInstanceOfTotal(Object item) {
        String totalTmp = null;
        int idP = ((Total)item).getIdProjet();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            totalTmp = df.format(nbht);
        }
        return totalTmp;
    }

    private String totalInstanceOfTacheTO(Object item, double nbh) {
        int idT = ((TacheTO)item).getIdTache();
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        return df.format(nbh);
    }

    public void selectAllDom() {
        this.selectedDom = new int[this.allDomaine.size()];
        for (int i = 0; i < this.allDomaine.size(); ++i) {
            this.selectedDom[i] = ((DomaineTO)this.allDomaine.get(i)).getIdDomaine();
        }
    }

    public void deSelectAllDom() {
        this.selectedDom = null;
    }

    public void download(HttpServletResponse response) throws LocalizedError, IOException {
        response.setContentType("text/csv");
        PrintWriter output = response.getWriter();
        try {
            for (Object o : this.items) {
                output.print(o + ";");
            }
        }
        catch (Exception e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        output.flush();
        output.close();
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public String getDateD() {
        return this.dateD;
    }

    public void setDateD(String dateD) {
        this.dateD = dateD;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public String getDateF() {
        return this.dateF;
    }

    public void setDateF(String dateF) {
        this.dateF = dateF;
    }

    public List<CollaborateurTO> getCollaborateurs() {
        return this.collaborateurs;
    }

    public void setCollaborateurs(List<CollaborateurTO> collaborateurs) {
        this.collaborateurs = collaborateurs;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<RecapProjetTO> getListRecap() {
        return this.listRecap;
    }

    public void setListRecap(List<RecapProjetTO> listRecap) {
        this.listRecap = listRecap;
    }

    public boolean isVoirTabl() {
        return this.voirTabl;
    }

    public void setVoirTabl(boolean voirTabl) {
        this.voirTabl = voirTabl;
    }

    public boolean isVoirDate() {
        return this.voirDate;
    }

    public void setVoirDate(boolean voirDate) {
        this.voirDate = voirDate;
    }

    public int[] getSelectedDom() {
        return this.selectedDom;
    }

    public void setSelectedDom(int[] selectedDom) {
        this.selectedDom = selectedDom;
    }

    public List<DomaineTO> getAllDomaine() {
        return this.allDomaine;
    }

    public void setAllDomaine(List<DomaineTO> allDomaine) {
        this.allDomaine = allDomaine;
    }

    public boolean isVoirDom() {
        return this.voirDom;
    }

    public void setVoirDom(boolean voirDom) {
        this.voirDom = voirDom;
    }
}

