/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.bilan;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.bilan.RecapProjetMensuelManager;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.to.bilan.CollaborateurRecapMensTO;
import org.jeinnov.jeitime.api.to.bilan.JourMois;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetMensuelTO;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.ui.utils.CalculJourDate;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class RecapProjetMensuelUIBean {
    private RecapProjetMensuelManager recapProjetMensuelManager = RecapProjetMensuelManager.getInstance();
    private ProjetManager projetManager = ProjetManager.getInstance();
    private CalculJourDate calCulJourDate = new CalculJourDate();
    private boolean voirTabl = false;
    private boolean voirProj = false;
    private boolean voirDate = true;
    private static int[] ALL_MOIS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private int mois;
    private int annee;
    private int[] selectedProjet;
    private List<ProjetTO> allprojet = new ArrayList();
    private List<JourMois> jour = new ArrayList();
    private List<RecapProjetMensuelTO> listRecap = new ArrayList();
    private List<Object> items = new ArrayList();
    private List<CollaborateurTO> collaborateurs = new ArrayList();

    public void load() {
        this.items = new ArrayList();
        this.jour = new ArrayList();
        this.listRecap = new ArrayList();
        this.allprojet = this.projetManager.getAll();
        this.voirDate = true;
        this.voirProj = false;
        this.voirTabl = false;
        Calendar cal = GregorianCalendar.getInstance();
        cal.getTime();
        this.annee = cal.get(1);
    }

    public void voirProjet() {
        this.voirProj = true;
    }

    public void reset() {
        this.items = new ArrayList();
        this.listRecap = new ArrayList();
        this.allprojet = new ArrayList();
        this.allprojet = this.projetManager.getAllNotLock();
        this.voirDate = true;
        this.voirProj = false;
        this.voirTabl = false;
        this.jour = new ArrayList();
        this.selectedProjet = null;
    }

    public void voirTableau() throws IError {
        Calendar cal = GregorianCalendar.getInstance();
        if (this.annee == 0) {
            cal.getTime();
            this.annee = cal.get(1);
        }
        Date dateDeb = this.calCulJourDate.calculDateDebut(cal, this.annee, this.mois);
        Date dateFin = this.calCulJourDate.calculDateFin(cal, this.annee, this.mois);
        this.items = new ArrayList();
        this.jour = new ArrayList();
        this.listRecap = new ArrayList();
        try {
            this.items = this.recapProjetMensuelManager.listCollab(this.selectedProjet);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun projet n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.listRecap = this.recapProjetMensuelManager.creerListRecapProjet(this.selectedProjet, dateDeb, dateFin);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun projet n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.calCulJourDate.nbrJour(this.annee, this.mois, this.getJour());
        this.voirTabl = true;
        this.voirProj = false;
        this.voirDate = false;
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=sousTitleTable>" + item + "</span>";
        }
        if (item instanceof Integer) {
            return " Total";
        }
        return ((CollaborateurRecapMensTO)item).getNomCollab() + " " + ((CollaborateurRecapMensTO)item).getPrenomCollab();
    }

    public String getValue(Object item, int j) {
        if (item instanceof String) {
            return null;
        }
        if (item instanceof Integer) {
            return this.itemsInstanceOfInteger(item, j);
        }
        return this.itemsInstanceOfCollaborateurRecapMensTO(item, j);
    }

    private String itemsInstanceOfInteger(Object item, int j) {
        String nb = "0";
        int idP = (Integer)item;
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetMensuelTO)this.listRecap.get(i)).getJour() != j || ((RecapProjetMensuelTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetMensuelTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfCollaborateurRecapMensTO(Object item, int j) {
        int idCo = ((CollaborateurRecapMensTO)item).getIdCollab();
        int idP = ((CollaborateurRecapMensTO)item).getIdProjet();
        String nb = "";
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (j != ((RecapProjetMensuelTO)this.listRecap.get(i)).getJour() || idCo != ((RecapProjetMensuelTO)this.listRecap.get(i)).getCollab().getIdColl() || idP != ((RecapProjetMensuelTO)this.listRecap.get(i)).getNomProjet().getIdProjet()) continue;
            double nbh = ((RecapProjetMensuelTO)this.listRecap.get(i)).getNbheure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        String total = "0";
        if (item instanceof String) {
            return null;
        }
        total = item instanceof Integer ? this.totalInstanceOfInteger(item, nbh) : this.totalInstanceOfCollaborateurRecapMensTO(item, nbh);
        return total;
    }

    private String totalInstanceOfInteger(Object item, double nbh) {
        int idP = (Integer)item;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idP != ((RecapProjetMensuelTO)this.listRecap.get(i)).getNomProjet().getIdProjet()) continue;
            nbh = ((RecapProjetMensuelTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    private String totalInstanceOfCollaborateurRecapMensTO(Object item, double nbh) {
        int idCo = ((CollaborateurRecapMensTO)item).getIdCollab();
        int idP = ((CollaborateurRecapMensTO)item).getIdProjet();
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idCo != ((RecapProjetMensuelTO)this.listRecap.get(i)).getCollab().getIdColl() || idP != ((RecapProjetMensuelTO)this.listRecap.get(i)).getNomProjet().getIdProjet()) continue;
            nbh = ((RecapProjetMensuelTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    public void selectAll() {
        this.selectedProjet = new int[this.allprojet.size()];
        for (int i = 0; i < this.allprojet.size(); ++i) {
            this.selectedProjet[i] = ((ProjetTO)this.allprojet.get(i)).getIdProjet();
        }
    }

    public void deSelectAll() {
        this.selectedProjet = null;
    }

    public void voirMoisSuiv() throws IError {
        if (this.mois == 11) {
            ++this.annee;
            this.mois = 0;
        } else {
            ++this.mois;
        }
        this.jour = new ArrayList();
        this.voirTableau();
    }

    public void voirMoisPrec() throws IError {
        if (this.mois == 0) {
            --this.annee;
            this.mois = 11;
        } else {
            --this.mois;
        }
        this.jour = new ArrayList();
        this.voirTableau();
    }

    public int[] getSelectedProjet() {
        return this.selectedProjet;
    }

    public void setSelectedProjet(int[] selectedProjet) {
        this.selectedProjet = selectedProjet;
    }

    public List<ProjetTO> getAllprojet() {
        return this.allprojet;
    }

    public void setAllprojet(List<ProjetTO> allprojet) {
        this.allprojet = allprojet;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<CollaborateurTO> getCollaborateurs() {
        return this.collaborateurs;
    }

    public void setCollaborateurs(List<CollaborateurTO> collaborateurs) {
        this.collaborateurs = collaborateurs;
    }

    public boolean isVoirTabl() {
        return this.voirTabl;
    }

    public void setVoirTabl(boolean voirTabl) {
        this.voirTabl = voirTabl;
    }

    public boolean isVoirProj() {
        return this.voirProj;
    }

    public void setVoirProj(boolean voirProj) {
        this.voirProj = voirProj;
    }

    public List<RecapProjetMensuelTO> getListRecap() {
        return this.listRecap;
    }

    public void setListRecap(List<RecapProjetMensuelTO> listRecap) {
        this.listRecap = listRecap;
    }

    public boolean isVoirDate() {
        return this.voirDate;
    }

    public void setVoirDate(boolean voirDate) {
        this.voirDate = voirDate;
    }

    public int getMois() {
        return this.mois;
    }

    public void setMois(int mois) {
        this.mois = mois;
    }

    public static int[] getAllMois() {
        return ALL_MOIS;
    }

    public int getAnnee() {
        return this.annee;
    }

    public void setAnnee(int annee) {
        this.annee = annee;
    }

    public List<JourMois> getJour() {
        return this.jour;
    }

    public void setJour(List<JourMois> jour) {
        this.jour = jour;
    }
}

