/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.collaborateur;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.api.service.affecter.AffecterException;
import org.jeinnov.jeitime.api.service.affecter.AffecterManager;
import org.jeinnov.jeitime.api.service.collaborateur.AppartientCollegeManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollegeManager;
import org.jeinnov.jeitime.api.service.collaborateur.EquipeManager;
import org.jeinnov.jeitime.api.service.collaborateur.RoleCollabManager;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.collaborateur.CollegeTO;
import org.jeinnov.jeitime.api.to.collaborateur.EquipeTO;
import org.jeinnov.jeitime.ui.collaborateur.ResultTransformerUIBean;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class CollaborateurUiBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private EquipeManager equipeManager = EquipeManager.getInstance();
    private CollaborateurManager collaborateurManager = CollaborateurManager.getInstance();
    private CollegeManager collegeManager = CollegeManager.getInstance();
    private ResultTransformerUIBean resultTransformer = new ResultTransformerUIBean();
    private int id;
    private int idColl;
    private String login;
    private String nomColl;
    private String prenomColl;
    private String password;
    private String confirmPass;
    private String oldPass;
    private String newPass;
    private String salaireColl = "0";
    private String chargeColl = "0";
    private int statutColl;
    private int contrat;
    private int[] selectedColl;
    private int[] selectedEquipe;
    private CollaborateurTO collaborateur;
    private List<CollaborateurTO> allCollaborateur;
    private List<CollaborateurTO> listRecap = new ArrayList();
    private EquipeTO equipColl;
    private List<EquipeTO> allEquip;
    private int idEqu;
    private CollegeTO college;
    private List<CollegeTO> allCollege;
    private Integer idCollege;
    private String strNbHeureLundi = "0";
    private String strNbHeureMardi = "0";
    private String strNbHeureMercredi = "0";
    private String strNbHeureJeudi = "0";
    private String strNbHeureVendredi = "0";
    private String strNbHeureAnnuel = "0";
    private String strNbHeureMens = "0";
    private String strNbHeureHeb = "0";
    private float nbHeureLundi = 0.0f;
    private float nbHeureMardi = 0.0f;
    private float nbHeureMercredi = 0.0f;
    private float nbHeureJeudi = 0.0f;
    private float nbHeureVendredi = 0.0f;
    private float nbHeureHeb = 0.0f;
    private float nbHeureMens = 0.0f;
    private float nbHeureAnn = 0.0f;
    private float salaire = 0.0f;
    private float charge = 0.0f;
    private static int[] ALL_STATUS = new int[]{0, 1, 2, 3};
    private static int[] ALL_CONTRAT = new int[]{0, 1};
    private boolean edit;

    public void loadInformations() {
        this.allCollege = new ArrayList();
        CollegeTO aucunCollege = new CollegeTO();
        aucunCollege.setIdCollege(0);
        aucunCollege.setNomCollege("aucun college");
        this.allCollege = this.collegeManager.getAll();
        this.allCollege.add(0, aucunCollege);
        this.allEquip = new ArrayList();
        EquipeTO aucuneEquipe = new EquipeTO();
        aucuneEquipe.setIdEquip(0);
        aucuneEquipe.setNomEquip("aucune \u00e9quipe");
        this.allEquip = this.equipeManager.getAll();
        this.allEquip.add(0, aucuneEquipe);
        this.statutColl = 3;
    }

    public void loadAll() {
        this.allCollaborateur = new ArrayList();
        this.allCollaborateur = this.collaborateurManager.getAll();
    }

    public void load(HttpServletRequest iRequest) throws IError {
        this.loadInformations();
        this.id = Integer.parseInt(iRequest.getParameter("id"));
        this.load();
    }

    public void load() throws IError {
        try {
            this.collaborateur = this.collaborateurManager.get(this.id);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Le collaborateur avec l'id " + this.id + " n'exsite pas.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.login = this.collaborateur.getLogin();
        this.nomColl = this.collaborateur.getNomColl();
        this.prenomColl = this.collaborateur.getPrenomColl();
        this.password = this.collaborateur.getPassword();
        this.salaireColl = String.valueOf(this.collaborateur.getSalairAnn());
        this.chargeColl = String.valueOf(this.collaborateur.getChargeAnn());
        this.statutColl = this.collaborateur.getStatut();
        this.equipColl = this.collaborateur.getEquipe();
        if (this.equipColl != null) {
            this.idEqu = this.equipColl.getIdEquip();
        }
        this.floatToStringCollaborateur();
        this.contrat = this.collaborateur.getContrat();
        this.idCollege = AppartientCollegeManager.getInstance().get(this.collaborateur.getIdColl());
        this.oldPass = null;
        this.newPass = null;
        this.confirmPass = null;
    }

    public void create() throws IError, CollaborateurException, ValidationErrors {
        int idCollab;
        NumberFormat nf = NumberFormat.getInstance(Locale.FRANCE);
        this.stringToFloatCollab(nf);
        this.nbHeureHeb = this.nbHeureLundi + this.nbHeureMardi + this.nbHeureMercredi + this.nbHeureJeudi + this.nbHeureVendredi;
        this.creerInfoHeureCollab(nf);
        EquipeTO equip = new EquipeTO(this.idEqu);
        this.password = this.collaborateurManager.passwordCrypting(this.password);
        this.confirmPass = this.collaborateurManager.passwordCrypting(this.confirmPass);
        this.collaborateur = new CollaborateurTO(this.id, this.login, this.nomColl, this.prenomColl, this.password, this.statutColl, this.salaire, this.charge, this.nbHeureLundi, this.nbHeureMardi, this.nbHeureMercredi, this.nbHeureJeudi, this.nbHeureVendredi, this.nbHeureHeb, this.nbHeureMens, this.nbHeureAnn, equip, this.contrat);
        int idC = this.idCollege == null ? 0 : this.idCollege;
        try {
            idCollab = this.collaborateurManager.saveOrUpdate(this.collaborateur);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue le collaborateur n'a pas pu \u00eatre sauvegard\u00e9 ce login : " + this.login + " est peut-\u00eatre d\u00e9j\u00e0 utilis\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        RoleCollabManager.getInstance().save(this.statutColl, idCollab);
        if (idC != 0) {
            AppartientCollegeManager.getInstance().saveOrUpdate(idC, idCollab);
        }
    }

    public void update() throws IError, CollaborateurException {
        int idCollab;
        NumberFormat nf = NumberFormat.getInstance();
        this.stringToFloatCollab(nf);
        this.nbHeureHeb = this.nbHeureLundi + this.nbHeureMardi + this.nbHeureMercredi + this.nbHeureJeudi + this.nbHeureVendredi;
        this.creerInfoHeureCollab(nf);
        EquipeTO equipe = new EquipeTO(this.idEqu);
        CollaborateurTO collab = new CollaborateurTO(this.id, this.login, this.nomColl, this.prenomColl, this.password, this.statutColl, this.salaire, this.charge, this.nbHeureLundi, this.nbHeureMardi, this.nbHeureMercredi, this.nbHeureJeudi, this.nbHeureVendredi, this.nbHeureHeb, this.nbHeureMens, this.nbHeureAnn, equipe, this.contrat);
        try {
            idCollab = this.collaborateurManager.saveOrUpdate(collab);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue le collaborateur n'a pas pu \u00eatre sauvegard\u00e9.ce login : " + this.login + " est peut-\u00eatre d\u00e9j\u00e0 utilis\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        RoleCollabManager.getInstance().save(this.statutColl, idCollab);
        if (this.idCollege != 0) {
            AppartientCollegeManager.getInstance().saveOrUpdate(this.idCollege.intValue(), idCollab);
        } else {
            AppartientCollegeManager.getInstance().deleteByIdCollaborateur(idCollab);
        }
    }

    public void validatePassword() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (!this.password.equalsIgnoreCase(this.confirmPass)) {
            errors.addItemError("collaborateurBean.confirmPass", (ValidationError)new LocalizedValidationError("validation.password"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void validateChangePassword() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        this.oldPass = this.collaborateurManager.passwordCrypting(this.oldPass);
        if (!this.newPass.equalsIgnoreCase(this.confirmPass)) {
            errors.addItemError("collaborateurBean.confirmPass", (ValidationError)new LocalizedValidationError("validation.password"));
        } else if (!this.oldPass.equalsIgnoreCase(this.password)) {
            errors.addItemError("collaborateurBean.oldPass", (ValidationError)new LocalizedValidationError("validation.oldPassword"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void validateChangePasswordByAdminUser() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (!this.newPass.equalsIgnoreCase(this.confirmPass)) {
            errors.addItemError("collaborateurBean.confirmPass", (ValidationError)new LocalizedValidationError("validation.password"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void changePassword(HttpServletRequest iRequest) throws CollaborateurException, IError {
        this.password = this.newPass = this.collaborateurManager.passwordCrypting(this.newPass);
        this.update();
    }

    public void selectCollege(int idC) throws IError {
        if (idC != 0) {
            this.floatToStringCollege(idC);
        } else {
            this.strNbHeureLundi = "0";
            this.strNbHeureMardi = "0";
            this.strNbHeureMercredi = "0";
            this.strNbHeureJeudi = "0";
            this.strNbHeureVendredi = "0";
            this.strNbHeureAnnuel = "0";
            this.strNbHeureMens = "0";
        }
    }

    public void delete(HttpServletRequest iRequest) throws IError, CollaborateurException {
        this.loadInformations();
        int idCollab = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            AppartientCollegeManager.getInstance().deleteByIdCollaborateur(idCollab);
            RoleCollabManager.getInstance().delete(idCollab);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Le collaborateur avec l'id " + idCollab + " n'exsite peut-\u00eatre pas.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            AffecterManager.getInstance().deleteAllForCollaborateur(idCollab);
        }
        catch (AffecterException e) {
            NonLocalizedError error = new NonLocalizedError("Le collaborateur avec l'id " + idCollab + " n'exsite peut-\u00eatre pas.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.collaborateurManager.delete(idCollab);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Le collaborateur avec l'id " + idCollab + " n'exsite peut-\u00eatre pas.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.loadAll();
    }

    public void selectCollaborateur(int idEq) {
        this.allCollaborateur = idEq == 0 ? null : this.collaborateurManager.getAllByIdEquipe(idEq);
    }

    public void refresh() {
    }

    public boolean isInLienTach(int id, String loginC) {
        boolean verif = this.collaborateurManager.isInLientTachUtil(id);
        if (loginC.equalsIgnoreCase("admin")) {
            verif = true;
        }
        return verif;
    }

    public void rempliSem(int idCo) throws IError {
        this.floatToStringCollege(idCo);
    }

    private void floatToStringCollaborateur() {
        this.strNbHeureLundi = this.resultTransformer.floatToStringLundi((Object)this.collaborateur);
        this.strNbHeureMardi = this.resultTransformer.floatToStringMardi((Object)this.collaborateur);
        this.strNbHeureMercredi = this.resultTransformer.floatToStringMercredi((Object)this.collaborateur);
        this.strNbHeureJeudi = this.resultTransformer.floatToStringJeudi((Object)this.collaborateur);
        this.strNbHeureVendredi = this.resultTransformer.floatToStringVendredi((Object)this.collaborateur);
        this.strNbHeureAnnuel = this.resultTransformer.floatToStringAnnuel((Object)this.collaborateur);
        this.strNbHeureMens = this.resultTransformer.floatToStringMensuel((Object)this.collaborateur);
    }

    private void floatToStringCollege(int idC) throws IError {
        CollegeTO c;
        try {
            c = this.collegeManager.get(idC);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucun college n'est s\u00e9lectionn\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.strNbHeureLundi = this.resultTransformer.floatToStringLundi((Object)c);
        this.strNbHeureMardi = this.resultTransformer.floatToStringMardi((Object)c);
        this.strNbHeureMercredi = this.resultTransformer.floatToStringMercredi((Object)c);
        this.strNbHeureJeudi = this.resultTransformer.floatToStringJeudi((Object)c);
        this.strNbHeureVendredi = this.resultTransformer.floatToStringVendredi((Object)c);
        this.strNbHeureAnnuel = this.resultTransformer.floatToStringAnnuel((Object)c);
        this.strNbHeureMens = this.resultTransformer.floatToStringMensuel((Object)c);
        this.strNbHeureHeb = this.resultTransformer.floatToStringHebdo((Object)c);
    }

    private void creerInfoHeureCollab(NumberFormat nf) throws IError {
        if (this.idCollege != 0) {
            CollegeTO col;
            try {
                col = this.collegeManager.get(this.idCollege.intValue());
            }
            catch (CollaborateurException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucun college n'est s\u00e9lectionn\u00e9", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            this.nbHeureHeb = col.getNbHeureHeb();
            this.nbHeureMens = col.getNbHeureMensCollege();
            this.nbHeureAnn = col.getNbHeureAnnCollege();
        } else {
            try {
                this.nbHeureMens = Float.parseFloat(this.strNbHeureMens);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    this.nbHeureMens = nf.parse(this.strNbHeureMens).floatValue();
                }
                catch (ParseException pe) {
                    this.logger.error((Object)pe.getMessage(), (Throwable)pe);
                }
            }
            try {
                this.nbHeureAnn = Float.parseFloat(this.strNbHeureAnnuel);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    this.nbHeureAnn = nf.parse(this.strNbHeureAnnuel).floatValue();
                }
                catch (ParseException pe) {
                    this.logger.error((Object)pe.getMessage(), (Throwable)pe);
                }
            }
        }
    }

    private void stringToFloatCollab(NumberFormat nf) {
        this.salaire = this.resultTransformer.stringToFloatSalaire(nf, this.salaireColl);
        this.charge = this.resultTransformer.stringToFloatChargeCollab(nf, this.chargeColl);
        this.nbHeureLundi = this.resultTransformer.stringToFloatLundi(nf, this.strNbHeureLundi);
        this.nbHeureMardi = this.resultTransformer.stringToFloatMardi(nf, this.strNbHeureMardi);
        this.nbHeureMercredi = this.resultTransformer.stringToFloatMercredi(nf, this.strNbHeureMercredi);
        this.nbHeureJeudi = this.resultTransformer.stringToFloatJeudi(nf, this.strNbHeureJeudi);
        this.nbHeureVendredi = this.resultTransformer.stringToFloatVendredi(nf, this.strNbHeureVendredi);
    }

    public int getIdColl() {
        return this.idColl;
    }

    public void setIdColl(int idColl) {
        this.idColl = idColl;
    }

    public int getContrat() {
        return this.contrat;
    }

    public void setContrat(int contrat) {
        this.contrat = contrat;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public static int[] getAllContrat() {
        return ALL_CONTRAT;
    }

    public CollegeTO getCollege() {
        return this.college;
    }

    public void setCollege(CollegeTO college) {
        this.college = college;
    }

    public List<CollegeTO> getAllCollege() {
        return this.allCollege;
    }

    public void setAllCollege(List<CollegeTO> allCollege) {
        this.allCollege = allCollege;
    }

    public Integer getIdCollege() {
        return this.idCollege;
    }

    public void setIdCollege(Integer idCollege) {
        this.idCollege = idCollege;
    }

    public EquipeTO getEquipColl() {
        return this.equipColl;
    }

    public void setEquipColl(EquipeTO equipColl) {
        this.equipColl = equipColl;
    }

    public List<EquipeTO> getAllEquip() {
        return this.allEquip;
    }

    public void setAllEquip(List<EquipeTO> allEquip) {
        this.allEquip = allEquip;
    }

    public int getIdEqu() {
        return this.idEqu;
    }

    public void setIdEqu(int idEqu) {
        this.idEqu = idEqu;
    }

    public CollaborateurTO getCollaborateur() {
        return this.collaborateur;
    }

    public void setCollaborateur(CollaborateurTO collaborateur) {
        this.collaborateur = collaborateur;
    }

    public List<CollaborateurTO> getAllCollaborateur() {
        return this.allCollaborateur;
    }

    public void setAllCollaborateur(List<CollaborateurTO> allCollaborateur) {
        this.allCollaborateur = allCollaborateur;
    }

    public int[] getSelectedEquipe() {
        return this.selectedEquipe;
    }

    public void setSelectedEquipe(int[] selectedEquipe) {
        this.selectedEquipe = selectedEquipe;
    }

    public List<CollaborateurTO> getListRecap() {
        return this.listRecap;
    }

    public void setListRecap(List<CollaborateurTO> listRecap) {
        this.listRecap = listRecap;
    }

    public int[] getSelectedColl() {
        return this.selectedColl;
    }

    public void setSelectedColl(int[] selectedColl) {
        this.selectedColl = selectedColl;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getNomColl() {
        return this.nomColl;
    }

    public void setNomColl(String nomColl) {
        this.nomColl = nomColl;
    }

    public String getPrenomColl() {
        return this.prenomColl;
    }

    public void setPrenomColl(String prenomColl) {
        this.prenomColl = prenomColl;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConfirmPass() {
        return this.confirmPass;
    }

    public void setConfirmPass(String confirmPass) {
        this.confirmPass = confirmPass;
    }

    public String getOldPass() {
        return this.oldPass;
    }

    public void setOldPass(String oldPass) {
        this.oldPass = oldPass;
    }

    public String getNewPass() {
        return this.newPass;
    }

    public void setNewPass(String newPass) {
        this.newPass = newPass;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getStatutColl() {
        return this.statutColl;
    }

    public void setStatutColl(int statutColl) {
        this.statutColl = statutColl;
    }

    public String getSalaireColl() {
        return this.salaireColl;
    }

    public void setSalaireColl(String salaireColl) {
        this.salaireColl = salaireColl;
    }

    public String getChargeColl() {
        return this.chargeColl;
    }

    public void setChargeColl(String chargeColl) {
        this.chargeColl = chargeColl;
    }

    public boolean isEdit() {
        this.edit = false;
        return this.edit;
    }

    public String getStrNbHeureLundi() {
        return this.strNbHeureLundi;
    }

    public void setStrNbHeureLundi(String nbHeureLundi) {
        this.strNbHeureLundi = nbHeureLundi;
    }

    public String getStrNbHeureMardi() {
        return this.strNbHeureMardi;
    }

    public void setStrNbHeureMardi(String nbHeureMardi) {
        this.strNbHeureMardi = nbHeureMardi;
    }

    public String getStrNbHeureMercredi() {
        return this.strNbHeureMercredi;
    }

    public void setStrNbHeureMercredi(String nbHeureMercredi) {
        this.strNbHeureMercredi = nbHeureMercredi;
    }

    public String getStrNbHeureJeudi() {
        return this.strNbHeureJeudi;
    }

    public void setStrNbHeureJeudi(String nbHeureJeudi) {
        this.strNbHeureJeudi = nbHeureJeudi;
    }

    public String getStrNbHeureVendredi() {
        return this.strNbHeureVendredi;
    }

    public void setStrNbHeureVendredi(String nbHeureVendredi) {
        this.strNbHeureVendredi = nbHeureVendredi;
    }

    public String getStrNbHeureAnnuel() {
        return this.strNbHeureAnnuel;
    }

    public void setStrNbHeureAnnuel(String strNbHeureAnnuel) {
        this.strNbHeureAnnuel = strNbHeureAnnuel;
    }

    public String getStrNbHeureMens() {
        return this.strNbHeureMens;
    }

    public void setStrNbHeureMens(String strNbHeureMens) {
        this.strNbHeureMens = strNbHeureMens;
    }

    public String getStrNbHeureHeb() {
        return this.strNbHeureHeb;
    }

    public void setStrNbHeureHeb(String strNbHeureHeb) {
        this.strNbHeureHeb = strNbHeureHeb;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public float getNbHeureLundi() {
        return this.nbHeureLundi;
    }

    public void setNbHeureLundi(float nbHeureLundi) {
        this.nbHeureLundi = nbHeureLundi;
    }

    public float getNbHeureMardi() {
        return this.nbHeureMardi;
    }

    public void setNbHeureMardi(float nbHeureMardi) {
        this.nbHeureMardi = nbHeureMardi;
    }

    public float getNbHeureMercredi() {
        return this.nbHeureMercredi;
    }

    public void setNbHeureMercredi(float nbHeureMercredi) {
        this.nbHeureMercredi = nbHeureMercredi;
    }

    public float getNbHeureJeudi() {
        return this.nbHeureJeudi;
    }

    public void setNbHeureJeudi(float nbHeureJeudi) {
        this.nbHeureJeudi = nbHeureJeudi;
    }

    public float getNbHeureVendredi() {
        return this.nbHeureVendredi;
    }

    public void setNbHeureVendredi(float nbHeureVendredi) {
        this.nbHeureVendredi = nbHeureVendredi;
    }

    public float getNbHeureHeb() {
        return this.nbHeureHeb;
    }

    public void setNbHeureHeb(float nbHeureHeb) {
        this.nbHeureHeb = nbHeureHeb;
    }

    public float getNbHeureMens() {
        return this.nbHeureMens;
    }

    public void setNbHeureMens(float nbHeureMens) {
        this.nbHeureMens = nbHeureMens;
    }

    public float getNbHeureAnn() {
        return this.nbHeureAnn;
    }

    public void setNbHeureAnn(float nbHeureAnn) {
        this.nbHeureAnn = nbHeureAnn;
    }

    public float getSalaire() {
        return this.salaire;
    }

    public void setSalaire(float salaire) {
        this.salaire = salaire;
    }

    public float getCharge() {
        return this.charge;
    }

    public void setCharge(float charge) {
        this.charge = charge;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }
}

