/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.collaborateur;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.api.service.collaborateur.AppartientCollegeManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.CollegeManager;
import org.jeinnov.jeitime.api.to.collaborateur.CollegeTO;
import org.jeinnov.jeitime.ui.collaborateur.ResultTransformerUIBean;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class CollegeUIBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CollegeManager collegeManager = CollegeManager.getInstance();
    private ResultTransformerUIBean resultTransformer = new ResultTransformerUIBean();
    private int idCollegeUI;
    private String nomCollegeUI;
    private String nbHeureLun;
    private String nbHeureMar;
    private String nbHeureMerc;
    private String nbHeureJeu;
    private String nbHeureVend;
    private float nbAnn = 0.0f;
    private float nbLun = 0.0f;
    private float nbMar = 0.0f;
    private float nbMerc = 0.0f;
    private float nbJeu = 0.0f;
    private float nbVen = 0.0f;
    private float nbMens = 0.0f;
    private float nbHeb = 0.0f;
    private String nbHeureHebdoCollegeUI;
    private String nbHeureMensCollegeUI;
    private String nbHeureAnnCollegeUI;
    private int nbJourCongeAnnCollegeUI;
    private int nbJourRttAnnCollegeUI;
    private boolean alertMoisUI;
    private boolean alertSemUI;
    private boolean alertAnnUI;
    private String listSaisie = null;
    private CollegeTO selected;
    private List<CollegeTO> allCollege;
    private int[] selectCollege;
    private boolean visible = false;

    public void loadAll() {
        this.allCollege = new ArrayList();
        this.allCollege = this.collegeManager.getAll();
        this.nbHeureLun = "0";
        this.nbHeureMar = "0";
        this.nbHeureMerc = "0";
        this.nbHeureJeu = "0";
        this.nbHeureVend = "0";
        this.nbHeureMensCollegeUI = "0";
        this.nbHeureAnnCollegeUI = "0";
        this.listSaisie = null;
    }

    public void select(HttpServletRequest iRequest) throws IError {
        this.selected = null;
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.selected = this.collegeManager.get(id);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucun college n'est s\u00e9lectionn\u00e9 ou le college s\u00e9lectionn\u00e9 n'existe plus dans la base", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.idCollegeUI = this.selected.getIdCollege();
        this.nomCollegeUI = this.selected.getNomCollege();
        this.floatToStringCollege();
        this.nbJourCongeAnnCollegeUI = this.selected.getNbJourCongeAnnCollege();
        this.nbJourRttAnnCollegeUI = this.selected.getNbJourRttAnnCollege();
        this.alertMoisUI = this.selected.isAlertMois();
        this.alertSemUI = this.selected.isAlertJour();
        this.alertAnnUI = this.selected.isAlertAnn();
        this.listSaisie = this.selected.getListSaisie();
        this.visible = true;
    }

    public void create() throws IError {
        NumberFormat nf = NumberFormat.getInstance();
        this.createDataWeekNumber(nf);
        this.createDataYearMonthNumber(nf);
        this.nbHeb = this.nbLun + this.nbMar + this.nbMerc + this.nbJeu + this.nbVen;
        CollegeTO college = new CollegeTO(this.idCollegeUI, this.nomCollegeUI, this.nbLun, this.nbMar, this.nbMerc, this.nbJeu, this.nbVen, this.nbHeb, this.nbMens, this.nbAnn, this.nbJourCongeAnnCollegeUI, this.nbJourRttAnnCollegeUI, this.alertMoisUI, this.alertSemUI, this.alertAnnUI, this.listSaisie);
        try {
            this.collegeManager.saveOrUpdate(college);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le coll\u00e8ge n'a pas pu \u00eatre enregistr\u00e9 dans la base, un coll\u00e8ge avec ce m\u00eame nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void update() throws IError {
        NumberFormat nf = NumberFormat.getInstance();
        this.createDataWeekNumber(nf);
        this.createDataYearMonthNumber(nf);
        this.nbHeb = this.nbLun + this.nbMar + this.nbMerc + this.nbJeu + this.nbVen;
        if (this.listSaisie.equals("")) {
            this.listSaisie = null;
        }
        CollegeTO college = new CollegeTO(this.idCollegeUI, this.nomCollegeUI, this.nbLun, this.nbMar, this.nbMerc, this.nbJeu, this.nbVen, this.nbHeb, this.nbMens, this.nbAnn, this.nbJourCongeAnnCollegeUI, this.nbJourRttAnnCollegeUI, this.alertMoisUI, this.alertSemUI, this.alertAnnUI, this.listSaisie);
        try {
            this.collegeManager.saveOrUpdate(college);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le coll\u00e8ge n'a pas pu \u00eatre enregistr\u00e9 dans la base. un coll\u00e8ge avec ce m\u00eame nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void delete(HttpServletRequest iRequest) throws IError, CollaborateurException {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        AppartientCollegeManager.getInstance().deleteByIdCollege(id);
        try {
            this.collegeManager.delete(id);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucun college n'est s\u00e9lectionn\u00e9 ou le college s\u00e9lectionn\u00e9 n'existe plus dans la base", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void cancel() {
        this.selected = null;
        this.visible = false;
        this.nomCollegeUI = null;
    }

    public void refresh() {
        this.idCollegeUI = 0;
        this.nomCollegeUI = null;
        this.nbJourCongeAnnCollegeUI = 0;
        this.nbJourRttAnnCollegeUI = 0;
        this.nbHeureLun = "0";
        this.nbHeureMar = "0";
        this.nbHeureMerc = "0";
        this.nbHeureJeu = "0";
        this.nbHeureVend = "0";
        this.nbHeureMensCollegeUI = "0";
        this.nbHeureAnnCollegeUI = "0";
        this.alertAnnUI = false;
        this.alertMoisUI = false;
        this.alertSemUI = false;
        this.listSaisie = null;
        this.selected = null;
        this.visible = false;
        this.allCollege = new ArrayList();
        this.allCollege = this.collegeManager.getAll();
    }

    private void floatToStringCollege() {
        this.nbHeureLun = this.resultTransformer.floatToStringLundi((Object)this.selected);
        this.nbHeureMar = this.resultTransformer.floatToStringMardi((Object)this.selected);
        this.nbHeureMerc = this.resultTransformer.floatToStringMercredi((Object)this.selected);
        this.nbHeureJeu = this.resultTransformer.floatToStringJeudi((Object)this.selected);
        this.nbHeureVend = this.resultTransformer.floatToStringVendredi((Object)this.selected);
        this.nbHeureAnnCollegeUI = this.resultTransformer.floatToStringAnnuel((Object)this.selected);
        this.nbHeureMensCollegeUI = this.resultTransformer.floatToStringMensuel((Object)this.selected);
    }

    private void createDataYearMonthNumber(NumberFormat nf) {
        try {
            this.nbAnn = Float.parseFloat(this.nbHeureAnnCollegeUI);
        }
        catch (Exception e) {
            try {
                this.nbAnn = nf.parse(this.nbHeureAnnCollegeUI).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
        try {
            this.nbMens = Float.parseFloat(this.nbHeureMensCollegeUI);
        }
        catch (Exception e) {
            try {
                this.nbMens = nf.parse(this.nbHeureMensCollegeUI).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
    }

    private void createDataWeekNumber(NumberFormat nf) {
        try {
            this.nbLun = Float.parseFloat(this.nbHeureLun);
        }
        catch (Exception e) {
            try {
                this.nbLun = nf.parse(this.nbHeureLun).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
        try {
            this.nbMar = Float.parseFloat(this.nbHeureMar);
        }
        catch (Exception e) {
            try {
                this.nbMar = nf.parse(this.nbHeureMar).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
        try {
            this.nbMerc = Float.parseFloat(this.nbHeureMerc);
        }
        catch (Exception e) {
            try {
                this.nbMerc = nf.parse(this.nbHeureMerc).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
        try {
            this.nbJeu = Float.parseFloat(this.nbHeureJeu);
        }
        catch (Exception e) {
            try {
                this.nbJeu = nf.parse(this.nbHeureJeu).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
        try {
            this.nbVen = Float.parseFloat(this.nbHeureVend);
        }
        catch (Exception e) {
            try {
                this.nbVen = nf.parse(this.nbHeureVend).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)pe);
            }
        }
    }

    public CollegeTO getSelected() {
        return this.selected;
    }

    public int[] getSelectCollege() {
        return this.selectCollege;
    }

    public void setSelectCollege(int[] selectCollege) {
        this.selectCollege = selectCollege;
    }

    public List<CollegeTO> getAllCollege() {
        return this.allCollege;
    }

    public void setAllCollege(List<CollegeTO> allCollege) {
        this.allCollege = allCollege;
    }

    public int getIdCollegeUI() {
        return this.idCollegeUI;
    }

    public void setIdCollegeUI(int idCollegeUI) {
        this.idCollegeUI = idCollegeUI;
    }

    public String getNomCollegeUI() {
        return this.nomCollegeUI;
    }

    public void setNomCollegeUI(String nomCollegeUI) {
        this.nomCollegeUI = nomCollegeUI;
    }

    public String getNbHeureLun() {
        return this.nbHeureLun;
    }

    public void setNbHeureLun(String nbHeureLun) {
        this.nbHeureLun = nbHeureLun;
    }

    public String getNbHeureMar() {
        return this.nbHeureMar;
    }

    public void setNbHeureMar(String nbHeureMar) {
        this.nbHeureMar = nbHeureMar;
    }

    public String getNbHeureMerc() {
        return this.nbHeureMerc;
    }

    public void setNbHeureMerc(String nbHeureMerc) {
        this.nbHeureMerc = nbHeureMerc;
    }

    public String getNbHeureJeu() {
        return this.nbHeureJeu;
    }

    public void setNbHeureJeu(String nbHeureJeu) {
        this.nbHeureJeu = nbHeureJeu;
    }

    public String getNbHeureVend() {
        return this.nbHeureVend;
    }

    public void setNbHeureVend(String nbHeureVend) {
        this.nbHeureVend = nbHeureVend;
    }

    public String getNbHeureMensCollegeUI() {
        return this.nbHeureMensCollegeUI;
    }

    public void setNbHeureMensCollegeUI(String nbHeureMensCollegeUI) {
        this.nbHeureMensCollegeUI = nbHeureMensCollegeUI;
    }

    public String getNbHeureAnnCollegeUI() {
        return this.nbHeureAnnCollegeUI;
    }

    public void setNbHeureAnnCollegeUI(String nbHeureAnnCollegeUI) {
        this.nbHeureAnnCollegeUI = nbHeureAnnCollegeUI;
    }

    public int getNbJourCongeAnnCollegeUI() {
        return this.nbJourCongeAnnCollegeUI;
    }

    public void setNbJourCongeAnnCollegeUI(int nbJourCongeAnnCollegeUI) {
        this.nbJourCongeAnnCollegeUI = nbJourCongeAnnCollegeUI;
    }

    public int getNbJourRttAnnCollegeUI() {
        return this.nbJourRttAnnCollegeUI;
    }

    public void setNbJourRttAnnCollegeUI(int nbJourRttAnnCollegeUI) {
        this.nbJourRttAnnCollegeUI = nbJourRttAnnCollegeUI;
    }

    public boolean isAlertMoisUI() {
        return this.alertMoisUI;
    }

    public void setAlertMoisUI(boolean alertMoisUI) {
        this.alertMoisUI = alertMoisUI;
    }

    public boolean isAlertSemUI() {
        return this.alertSemUI;
    }

    public void setAlertSemUI(boolean alertSemUI) {
        this.alertSemUI = alertSemUI;
    }

    public boolean isAlertAnnUI() {
        return this.alertAnnUI;
    }

    public void setAlertAnnUI(boolean alertAnnUI) {
        this.alertAnnUI = alertAnnUI;
    }

    public String getListSaisie() {
        return this.listSaisie;
    }

    public void setListSaisie(String listSaisie) {
        this.listSaisie = listSaisie;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getNbHeureHebdoCollegeUI() {
        return this.nbHeureHebdoCollegeUI;
    }

    public void setNbHeureHebdoCollegeUI(String nbHeureHebdoCollegeUI) {
        this.nbHeureHebdoCollegeUI = nbHeureHebdoCollegeUI;
    }
}

