/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.TypeProjetManager;
import org.jeinnov.jeitime.api.to.projet.TypeProjetTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class TypeProjetUIBean {
    private TypeProjetManager typeProjetManager = TypeProjetManager.getInstance();
    private int idTypeProjet;
    private String nomTypeProjet;
    private TypeProjetTO selected;
    private List<TypeProjetTO> allTypProj;

    public void load() {
        this.allTypProj = new ArrayList();
        this.allTypProj = this.typeProjetManager.getAll();
    }

    public void create() throws IError {
        TypeProjetTO typProj = new TypeProjetTO(this.idTypeProjet, this.nomTypeProjet);
        try {
            this.typeProjetManager.saveOrUpdate(typProj);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le type de projet n'a pas pu \u00eatre sauvegard\u00e9. Un type de projet avec ce  nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void update() throws IError {
        int id = this.selected.getIdTypeProj();
        String nom = this.selected.getNomTypePro();
        TypeProjetTO typProj = new TypeProjetTO(id, nom);
        try {
            this.typeProjetManager.saveOrUpdate(typProj);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le type de projet n'a pas pu \u00eatre sauvegard\u00e9. Un type de projet avec ce  nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.typeProjetManager.delete(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le type de projet selectionn\u00e9 n'a pas pu \u00eatre supprim\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void cancel() {
        this.selected = null;
    }

    public void refresh() {
        this.idTypeProjet = 0;
        this.nomTypeProjet = null;
        this.selected = null;
        this.allTypProj = new ArrayList();
        this.allTypProj = this.typeProjetManager.getAll();
    }

    public void select(HttpServletRequest iRequest) throws IError {
        this.selected = null;
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.selected = this.typeProjetManager.get(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le type de projet s\u00e9lectionn\u00e9 n'a pas pu \u00eatre charg\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public boolean isInProject(int id) throws ProjetException {
        boolean verif = this.typeProjetManager.isInProjet(id);
        return verif;
    }

    public List<TypeProjetTO> getAllTypProj() {
        return this.allTypProj;
    }

    public void setAllTypProj(List<TypeProjetTO> allTypProj) {
        this.allTypProj = allTypProj;
    }

    public TypeProjetTO getSelected() {
        return this.selected;
    }

    public int getIdTypeProjet() {
        return this.idTypeProjet;
    }

    public void setIdTypeProjet(int idTypeProjet) {
        this.idTypeProjet = idTypeProjet;
    }

    public String getNomTypeProjet() {
        return this.nomTypeProjet;
    }

    public void setNomTypeProjet(String nomTypeProjet) {
        this.nomTypeProjet = nomTypeProjet;
    }
}

