/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.utils;

import java.io.PrintWriter;
import java.sql.Date;
import java.util.Calendar;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.xml.base.html.table.Table;
import org.ow2.opensuit.xml.base.html.table.TableRenderingContext;
import org.ow2.opensuit.xml.base.html.table.export.ITableExportFormat;
import org.ow2.opensuit.xmlmap.annotations.XmlAncestor;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlDoc(value="This component is able to export table data to CSV format (Comma Separated Values).")
@XmlElement
public class CSVExport
implements ITableExportFormat,
IInitializable {
    @XmlDoc(value="Filename. By default, uses the Table ID.")
    @XmlAttribute(name="FileName", required=false)
    private String filename = null;
    @XmlDoc(value="File extension. By default 'csv'.")
    @XmlAttribute(name="FileExtension", required=false)
    private String fileExtension = "csv";
    @XmlDoc(value="Separator to use. Default: 'text/cvs'.")
    @XmlAttribute(name="MimeType", required=false)
    private String mimeType = "text/csv";
    @XmlDoc(value="Separator to use. Default: ','.")
    @XmlAttribute(name="Separator", required=false)
    private String separator = ",";
    @XmlAncestor
    private Table table;

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        if (this.fileExtension.startsWith(".")) {
            this.fileExtension = this.fileExtension.substring(1);
        }
    }

    public String getFileName() {
        if (this.filename == null) {
            return this.table.getId() + "." + this.fileExtension;
        }
        return this.filename + "." + this.fileExtension;
    }

    public void exportData(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, Collection<?> data) throws Exception {
        OpenSuitSession session = OpenSuitSession.getSession((HttpServletRequest)iRequest);
        iResponse.setContentType(this.mimeType + ";charset=" + session.getLocaleConfig().getCharSet());
        iResponse.setHeader("Cache-Control", "no-cache");
        iResponse.setHeader("Pragma", "no-cache");
        iResponse.setDateHeader("Expires", 0L);
        iRequest.setAttribute("$context", (Object)context);
        PrintWriter writer = iResponse.getWriter();
        int iDisplayedCol = 0;
        for (TableRenderingContext.ColumnDef col : context.getColumns()) {
            if (!col.isVisible()) continue;
            if (iDisplayedCol > 0) {
                writer.print(this.separator);
            }
            CSVExport.write2CSV((PrintWriter)writer, (Object)col.getProvider().getColumnTitle(iRequest, col));
            ++iDisplayedCol;
        }
        writer.print('\n');
        if (data != null) {
            for (Object rowObj : data) {
                iRequest.setAttribute(context.getTable().getRowBeanName(), rowObj);
                iDisplayedCol = 0;
                for (TableRenderingContext.ColumnDef col : context.getColumns()) {
                    if (!col.isVisible()) continue;
                    if (iDisplayedCol > 0) {
                        writer.print(this.separator);
                    }
                    Object cellData = col.getProvider().getCellDisplayedContent(iRequest, col, rowObj);
                    String cellTest = String.valueOf(cellData);
                    String[] params = cellTest.split("<");
                    String[] myCurrParam = null;
                    for (int i = 0; i < params.length; ++i) {
                        myCurrParam = params[i].split(">");
                        for (int j = 0; j < myCurrParam.length; ++j) {
                            if (j != 1 || i != 1) continue;
                            cellData = myCurrParam[1];
                        }
                    }
                    CSVExport.write2CSV((PrintWriter)writer, (Object)cellData);
                    ++iDisplayedCol;
                }
                writer.print('\n');
            }
        }
        writer.flush();
    }

    private static void write2CSV(PrintWriter writer, Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass() == Boolean.class || value.getClass() == Boolean.TYPE) {
            writer.print(String.valueOf(value));
        } else if (Number.class.isInstance(value)) {
            writer.print(String.valueOf(value));
        } else if (value.getClass().isPrimitive()) {
            writer.print(String.valueOf(value));
        } else if (Date.class.isInstance(value) || Calendar.class.isInstance(value)) {
            writer.print(String.valueOf(value));
        } else {
            String text = String.valueOf(value);
            int nbChars = text.length();
            writer.print('\"');
            block3: for (int i = 0; i < nbChars; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '\"': {
                        writer.print("\"\"");
                        continue block3;
                    }
                    default: {
                        writer.print(c);
                    }
                }
            }
            writer.print('\"');
        }
    }
}

