/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;

public class HibernateUtil {
    public static SessionFactory sessionFactory;
    private static Logger logger;
    public static AnnotationConfiguration configuration;
    static Properties properties;
    public static final ThreadLocal session;

    public static SessionFactory getSessionFactory() throws HibernateException {
        return sessionFactory;
    }

    public static AnnotationConfiguration getConfiguration() {
        if (configuration == null) {
            throw new IllegalStateException("Configuration not initialized yet");
        }
        return configuration;
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        logger = Logger.getLogger(HibernateUtil.class);
        try {
            URL configUrl = null;
            if (System.getProperty("hibernate.default.config") != null) {
                try {
                    configUrl = new URL(System.getProperty("hibernate.default.config"));
                }
                catch (MalformedURLException e) {
                    logger.error((Object)"Default hibernate url not valid.", (Throwable)e);
                }
            }
            if (configUrl == null) {
                configuration = new AnnotationConfiguration();
                configuration.configure();
                sessionFactory = configuration.buildSessionFactory();
            } else {
                sessionFactory = new AnnotationConfiguration().configure(configUrl).buildSessionFactory();
            }
        }
        catch (HibernateException e) {
            logger.warn((Object)e);
        }
        session = new ThreadLocal();
    }
}

