/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.utils;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.collaborateur.RoleCollabManager;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollaborateurP;
import org.jeinnov.jeitime.persistence.bo.collaborateur.RolesCollab;

public class JDBCLoginModule
implements LoginModule {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CallbackHandler callbackHandler = null;
    private Subject subject = null;
    private boolean success = false;
    private boolean commited = false;
    private CollaborateurP collab;
    private List<RolesCollab> roles;
    private RolesCollab rolesC;

    @Override
    public boolean abort() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (!this.commited) {
            this.reset();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.success) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.collab)) {
            this.subject.getPrincipals().add((Principal)this.collab);
        }
        if (!this.subject.getPrincipals().contains(this.roles)) {
            this.subject.getPrincipals().add((Principal)this.rolesC);
        }
        this.commited = true;
        return true;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Erreur : pas de callback");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Nom : "), new PasswordCallback("Mot de passe :", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String userName = ((NameCallback)callbacks[0]).getName();
            char[] ac = ((PasswordCallback)callbacks[1]).getPassword();
            char[] pass = new char[ac.length];
            System.arraycopy(ac, 0, pass, 0, ac.length);
            String password = new String(pass);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.success = this.rdbValidate(userName, password);
            callbacks[0] = null;
            callbacks[1] = null;
            if (!this.success) {
                throw new LoginException("Authentification incorrecte !");
            }
            this.logger.info((Object)"Vous \u00eates maintenant connect\u00e9");
            return this.success;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean logout() throws LoginException {
        for (CollaborateurP collaborateurP : this.subject.getPrincipals()) {
            this.subject.getPrincipals().remove(collaborateurP);
        }
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    private boolean rdbValidate(String userName, String password) throws CollaborateurException {
        boolean passwordMatch = false;
        CollaborateurP collab2 = CollaborateurManager.getInstance().getByLogin(userName);
        String dbPassword = collab2.getPassword();
        int id = collab2.getIdColl();
        String dbLogin = collab2.getLogin();
        if (dbPassword == null) {
            this.logger.info((Object)"ulitsateur ou mot de passe incorrect !!");
        }
        String passwordTmp = CollaborateurManager.getInstance().passwordCrypting(password);
        passwordMatch = passwordTmp.equals(dbPassword);
        this.collab = new CollaborateurP(dbLogin);
        List rolesTmp = RoleCollabManager.getInstance().getByCollaborateurId(id);
        this.roles = new ArrayList();
        for (RolesCollab rC : rolesTmp) {
            String nom = rC.getRole().getRoles();
            this.rolesC = new RolesCollab(nom);
            this.roles.add(this.rolesC);
        }
        return passwordMatch;
    }

    private void reset() {
        this.success = false;
        this.callbackHandler = null;
        this.subject = null;
        this.commited = false;
    }
}

