/*------------------------------------------------------------------------------
 * FT / ROSI / DPS
 *------------------------------------------------------------------------------
 * Project     : MLTV2
 * Sub-Project : Portail Web
 *------------------------------------------------------------------------------
 * File        : $Workfile$
 * Author      : Pierre SMEYERS
 * 
 * Description :
 *   The IPortal implementation.
 *   Also contains static methods to instanciate the whole portal model from
 *   the XML declarative format (this is based on "implicit XML mapping").
 *------------------------------------------------------------------------------
 * $Log: Portal.java,v $
 * Revision 1.1.2.4  2006/09/29 13:06:15  mltal
 * divers
 *
 * Revision 1.1.2.3  2006/09/05 09:22:30  mltal
 * Introduction of Images Validation.
 * Imlemented for menu page, button ands zacs
 *
 * Revision 1.1.2.2  2006/09/01 12:57:27  mltal
 * Refactoring and new components.
 *
 * Revision 1.1.2.1  2006/08/25 15:40:50  mltal
 * 1) ANT task for Bricks: generate Mockup, generate XSD, convert JSP 2 Java, generate Javadoc
 * 2) lots of refactoring of Bricks framework (Portal components moved into 'components' package)
 * 3) several new Zac implemented: Credit, Messages, ActuTV
 *
 * Revision 1.1.2.3  2006/08/22 09:11:54  mltal
 * Scripts ANT pour framework Bricks
 *
 * Revision 1.1.2.2  2006/08/21 14:47:05  mltal
 * Javadoc and comments.
 *
 */
package com.ebm_ws.infra.bricks.components.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ebm_ws.infra.bricks.components.base.binding.IDataSource;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.error.DefaultErrorHandler;
import com.ebm_ws.infra.bricks.components.base.error.ErrorHandler;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.locale.ILocaleSelector;
import com.ebm_ws.infra.bricks.components.base.locale.LocaleConfig;
import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.components.base.msg.ResourceBundle;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.bricks.impl.context.BricksSessionImpl;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.session.IPageContext;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Application implements IRequestProcessor, IXmlObject, IBeanProvider
{
	private static Log logger = LogFactory.getLog(Application.class);

	private final static String HANDLER_PARAMNAME = "_hdl_";
//	private final static String RENDERER_PARAMNAME = "_view_";
	
	// --- XML Mapping fields
	private String _xmlattr_req_HomePage;
//	private String _xmlattr_opt_CharSet = "iso-8859-1";
//	private String _xmlattr_req_Languages;
	
	// --- declared languages
	private LocaleConfig[] _xmlnode_1_unb_SupportedLocales;
	// --- locale policy
	private ILocaleSelector _xmlnode_req_LocaleSelector;
	// --- message providers
	private MessageProvider[] _xmlnode_1_unb_MessagesProviders;
	// --- error handler
	private ErrorHandler _xmlnode_opt_ErrorHandler = new DefaultErrorHandler();
	// --- data sources
	private IDataSource[] _xmlnode_0_unb_GlobalBeans;
	// --- global rules
	private RuleDefinition[] _xmlnode_0_unb_Rules;
	// --- frames
	private IFrame[] _xmlnode_1_unb_Frames;
	// --- pages
	private IPage[] _xmlnode_1_unb_Pages;
	
	private ServletContext _servletContext;
	
	private long startupTime = System.currentTimeMillis();
	private static long EXPIRATION_DELAY = 24 * 60 * 60 * 1000; // one day
	
	private HashMap<String, ILocaleConfig> _code2LocaleConfig = new HashMap<String, ILocaleConfig>();
	private HashMap<String, IPage> _name2Page = new HashMap<String, IPage>();
	private com.ebm_ws.infra.bricks.components.base.msg.ResourceBundle _bricksMessages = new ResourceBundle(BricksMessages.getBundleBaseName());
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		_servletContext = ((IValidationSupport)iValidSupport).getServletContext();
		
		// --- check rules don't have the same Name
		if(_xmlnode_0_unb_Rules != null)
		{
			ArrayList<String> ids = new ArrayList<String>();
			for(int i=0; i<_xmlnode_0_unb_Rules.length; i++)
			{
				if(_xmlnode_0_unb_Rules[i].getName() == null)
					continue;
				if(ids.contains(_xmlnode_0_unb_Rules[i].getName()))
					iErrors.logMessage(this, "Rules", IValidityLogger.ERROR, "More than one rules with name '"+_xmlnode_0_unb_Rules[i].getName()+"'.");
				else
					ids.add(_xmlnode_0_unb_Rules[i].getName());
			}
		}
		/*
		// --- check activities don't have the same Name
		if(_xmlnode_1_unb_Activities != null)
		{
			Vector ids = new Vector();
			for(int i=0; i<_xmlnode_1_unb_Activities.length; i++)
			{
				if(_xmlnode_1_unb_Activities[i].getName() == null)
					continue;
				if(ids.contains(_xmlnode_1_unb_Activities[i].getName()))
					iErrors.logMessage(this, "Activities", IValidityLogger.ERROR, "More than one activities with name '"+_xmlnode_1_unb_Activities[i].getName()+"'.");
				else
					ids.addElement(_xmlnode_1_unb_Activities[i].getName());
			}
		}
		*/
		// --- check pages don't have the same Name
		if(_xmlnode_1_unb_Pages != null)
		{
			for(int i=0; i<_xmlnode_1_unb_Pages.length; i++)
			{
				if(_xmlnode_1_unb_Pages[i] == null)
					continue;
				if(_xmlnode_1_unb_Pages[i].getName() == null)
					continue;
				if(_name2Page.get(_xmlnode_1_unb_Pages[i].getName()) != null)
					iErrors.logMessage((IXmlObject)_xmlnode_1_unb_Pages[i], "Pages", IValidityLogger.ERROR, "More than one page with name '"+_xmlnode_1_unb_Pages[i].getName()+"'.");
				else
					_name2Page.put(_xmlnode_1_unb_Pages[i].getName(), _xmlnode_1_unb_Pages[i]);
			}
		}
		/*
		// --- check pages don't have the same Name
		if(_xmlnode_1_unb_Pages != null)
		{
			Vector ids = new Vector();
			for(int i=0; i<_xmlnode_1_unb_Pages.length; i++)
			{
				if(_xmlnode_1_unb_Pages[i].getName() == null)
					continue;
				if(ids.contains(_xmlnode_1_unb_Pages[i].getName()))
					iErrors.logMessage(this, "Pages", IValidityLogger.ERROR, "More than one page with ID '"+_xmlnode_1_unb_Pages[i].getName()+"'.");
				else
					ids.addElement(_xmlnode_1_unb_Pages[i].getName());
			}
		}
		*/
		
		// --- check the home page exists
		if(_xmlattr_req_HomePage == null)
			iErrors.logMessage(this, "HomePage", IValidityLogger.ERROR, "No HomePage defined.");
		else if(getHomePage() == null)
			iErrors.logMessage(this, "HomePage", IValidityLogger.ERROR, "HomePage '"+_xmlattr_req_HomePage+"' does not exist.");
		
		// --- build locales hashtable
		for(int i=_xmlnode_1_unb_SupportedLocales.length-1; i>= 0; i--)
		{
			Locale loc = _xmlnode_1_unb_SupportedLocales[i].getLocale();
			_code2LocaleConfig.put(loc.getLanguage(), _xmlnode_1_unb_SupportedLocales[i]);
			if(loc.getCountry() != null && loc.getCountry().length() > 0)
				_code2LocaleConfig.put(loc.getLanguage()+"_"+loc.getCountry(), _xmlnode_1_unb_SupportedLocales[i]);
		}
	}
	public ServletContext getServletContext()
	{
		return _servletContext;
	}
	/*
	public String getCharSet()
	{
	    return _xmlattr_opt_CharSet;
	}
	*/
	public IPage getHomePage()
	{
		return getPage(_xmlattr_req_HomePage);
	}
	public MessageProvider getMessageProvider(String iProviderName)
	{
		if(_xmlnode_1_unb_MessagesProviders != null)
		{
			if(iProviderName == null)
				// --- return default
				return _xmlnode_1_unb_MessagesProviders[0];
			for(int i=0; i<_xmlnode_1_unb_MessagesProviders.length; i++)
			{
				if(iProviderName.equals(_xmlnode_1_unb_MessagesProviders[i].getName()))
					return _xmlnode_1_unb_MessagesProviders[i];
			}
		}
		
		// --- provider not found: is it the bricks one?
		if("bricks".equals(iProviderName))
			return _bricksMessages;
		
		return null;
	}
	/*
	private Bean getBean(String iName)
	{
		if(_xmlnode_0_unb_Beans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_Beans.length; i++)
		{
			if(iName.equals(_xmlnode_0_unb_Beans[i].getName()))
				return _xmlnode_0_unb_Beans[i];
		}
		return null;
	}
	*/
	public IBoolExpr getRule(String iName)
	{
		if(_xmlnode_0_unb_Rules == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_Rules.length; i++)
		{
			if(iName.equals(_xmlnode_0_unb_Rules[i].getName()))
				return _xmlnode_0_unb_Rules[i].getBoolExpr();
		}
		return null;
	}
	public IFrame getFrame(String iFrameName)
	{
		if(_xmlnode_1_unb_Frames == null)
			return null;
		if(iFrameName == null)
			// --- return default
			return _xmlnode_1_unb_Frames[0];
		for(int i=0; i<_xmlnode_1_unb_Frames.length; i++)
		{
			if(iFrameName.equals(_xmlnode_1_unb_Frames[i].getName()))
				return _xmlnode_1_unb_Frames[i];
		}
		return null;
	}
	public IPage getPage(String iPageName)
	{
		if(iPageName == null)
			iPageName = _xmlattr_req_HomePage;
		return _name2Page.get(iPageName);
	}
	public ILocaleConfig[] getAllLanguages()
	{
		return _xmlnode_1_unb_SupportedLocales;
	}
	public ILocaleConfig getLocaleConfig(Locale iLocale)
	{
	    if(iLocale == null)
	    {
	        // --- use the first one
	        return _xmlnode_1_unb_SupportedLocales[0];
	    }
		// --- try with language and country
		if(iLocale.getCountry() != null && iLocale.getCountry().length() > 0)
		{
			ILocaleConfig config = _code2LocaleConfig.get(iLocale.getLanguage()+"_"+iLocale.getCountry());
			if(config != null)
				return config;
		}
		// --- try with language
		ILocaleConfig config = _code2LocaleConfig.get(iLocale.getLanguage());
		if(config != null)
			return config;
		
		// --- return default (first)
		return _xmlnode_1_unb_SupportedLocales[0];
	}
	
	private static Class[] SERVICE_METHOD_SIGNATURE = {HttpServletRequest.class, HttpServletResponse.class};
	

	/*
	 * Process the incoming request
	 */
	public void service(HttpServletRequest iRequest, HttpServletResponse iResponse) throws IOException
	{
		logger.debug("service(): "+iRequest.getRequestURL());
//System.out.println("--> request: "+iRequest.getRequestURL()+" ("+iRequest.getContentType()+")");
		// --- analyse request uri
		BricksUrlBuilder requestUri = BricksUrlBuilder.copyFromRequest(iRequest, false);
		
		boolean isHtml = true;

		try
		{
			// --- set current request
			BricksSessionImpl.enterRequest(iRequest, iResponse);
			
			// --- create Bricks session if need be
			// --- TODO: manage session timeout ?
			BricksSessionImpl session = BricksSessionImpl.getSession(iRequest);
			if(session == null)
			{
				session = new BricksSessionImpl(this);
				BricksSessionImpl.setSession(iRequest, session);
			}
			
			// --- set request encoding (from previous Locale Config)
			if(session.getLocaleConfig() != null)
				iRequest.setCharacterEncoding(session.getLocaleConfig().getCharSet());
			
			// --- update session locale
			Locale localeFromPolicy = _xmlnode_req_LocaleSelector.getLocale(iRequest);
			ILocaleConfig localeConfig = getLocaleConfig(localeFromPolicy);
			if(localeFromPolicy == null)
			    localeFromPolicy = localeConfig.getLocale();
			session.setLocaleConfig(localeConfig);
			iResponse.setLocale(localeFromPolicy);
			// Servlet 2.4		iResponse.setCharacterEncoding(_xmlattr_opt_CharSet);

			// --- analyse request type
			if(requestUri.getSelector() == null || requestUri.getSelector().equals(BricksUrlBuilder.PAGE_SELECTOR))
			{
				// --- page rendering request
				String pageName = requestUri.getPath();
				if("Error".equals(pageName))
				{
					// --- render the error page
					_xmlnode_opt_ErrorHandler.servePage(iRequest, iResponse);
				}
				else
				{
					// --- render an application page
					
					// --- invoke action handler (if requested)
					String handler = iRequest.getParameter(HANDLER_PARAMNAME);
					if(handler != null)
					{
						int i = handler.lastIndexOf('.');
						String actionHandlerId = handler.substring(0, i);
						String actionHandlerMethod = handler.substring(i+1);

//						System.out.println("Handle action: "+actionHandlerId+"."+actionHandlerMethod+"(request, response)...");
						
						Object obj = getHandler(actionHandlerId);
						// --- invoke method <method>(HttpServletRequest, HttpServletResponse);
						// --- Application may throw an error
						Method m = obj.getClass().getMethod(actionHandlerMethod, SERVICE_METHOD_SIGNATURE);
						m.invoke(obj, new Object[]{iRequest, iResponse});
						
						// --- if a redirect was sent or the page was flushed, return
						if(iResponse.isCommitted())
							return;
						
						// TODO: si un send redirect a t envoy, faire des trucs (persister l'tat de la requete?) puis quitter
						// TODO: si pas de redirect aprs un POST il faut afficher la page en cours... fait-on un redirect malgr tout (pour supporter le BACK)?
						// oui, mais il faut virer le handler des paramtres (sinon on va processer 2 fois l'action)
						// par ailleurs il faudrait persister la requete (pour rcuprer notamment les erreurs de validation)
					}
					
					// --- prepare to display an application page
					// --- get page
					IPage page = getPage(pageName);
					if(page == null)
					{
						// --- resource not found: 404
						//TODO: localized error ?
						logger.debug("Page '"+pageName+"' not found.");
						iResponse.sendError(404);
						return;
					}
					// --- check authorization
					if(!page.getContextDef().isAuthorized(iRequest))
					{
						// --- 401: unauthorized (a different authentication may solve the problem)
						//TODO: localized error ?
						logger.debug("Page '"+pageName+"' not authorized.");
						iResponse.sendError(401);
						return;
					}
					
					// --- update page context
					// --- extract page context from request (may throw an IllegalArgumentException if required params not found)
					IPageContext context = page.getContextDef().extractContext(iRequest);
					
					if(!context.isSameContext(session.getCurrentPageContext()))
					{
						// --- change current context: quit previous, set and load new one
						if(session.getCurrentPageContext() != null)
						{
							session.getCurrentPageContext().getContextDef().quit(iRequest);
						}
						
						// --- set new page context as current
						session.setCurrentPageContext(context);
						try
						{
							context.getContextDef().load(iRequest);
						}
						catch(Throwable t)
						{
							// --- page context loading failed: cleanup and rethrow error
							session.setCurrentPageContext(null);
							throw t;
						}
					}
					context = session.getCurrentPageContext();
					
					// --- render page
					page.servePage(iRequest, iResponse);
				}
			}
			else if(requestUri.getSelector().equals(BricksUrlBuilder.SERVICE_SELECTOR))
			{
				// --- this is a service request
				isHtml = false;// ???

				String[] rendererTokens = requestUri.getPathTokens();
				if(rendererTokens == null || rendererTokens.length != 2)
				{
					// --- error
					logger.error("Invalid Path in Service Request: "+requestUri.getPath());
					iResponse.sendError(500);
					return;
				}
				String rendererId = rendererTokens[0];
				String rendererMethod = rendererTokens[1];
				
				Object renderer = getHandler(rendererId);
				// --- invoke method <method>(HttpServletRequest, HttpServletResponse);
				// --- Application may throw an error
				Method serviceMethod = renderer.getClass().getMethod(rendererMethod, SERVICE_METHOD_SIGNATURE);
				
				// --- invoke the renderer method
				serviceMethod.invoke(renderer, new Object[]{iRequest, iResponse});
			}
			else if(requestUri.getSelector().equals(BricksUrlBuilder.RESOURCE_SELECTOR))
			{
				// --- this is a resource request
				isHtml = false;
				
				// --- 1: Cache management
				// --- note: we could retrieve the lastModified on the file (exists on File and ZipEntry)
				long lastModified = startupTime;
				if("GET".equals(iRequest.getMethod()))
				{
					long ifModifiedSince = iRequest.getDateHeader("If-Modified-Since");
					// --- date headers don't contain milliseconds: test the seconds value
					if((lastModified / 1000L) <= (ifModifiedSince / 1000L))
					{
						// --- 304: not modified
//						System.out.println("--> use cache for "+requestUri.getPath());
						iResponse.setStatus(304);
						return;
					}
				}
				
				// --- 2: server the requested resource
				// --- retrieve the resource path
				String resourcePath = requestUri.getPath();
				if(resourcePath == null)
				{
					logger.error("Resource url does not contain any resource path.");
					iResponse.sendError(404);// resource not found
					return;
				}
				// --- check the resource is authorized (a file "<name>.res" must exist in the same directory)
				URL authorization = this.getClass().getClassLoader().getResource(resourcePath+".res");
				if(authorization == null)
				{
					// --- 403: forbidden (for any authentication)
					logger.error("Requested resource '"+resourcePath+"' not authorized.");
					iResponse.sendError(403);
					return;
				}
				
				// --- load the input stream
				InputStream input = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
				if(input == null)
				{
					logger.error("Resource '"+resourcePath+"' not found.");
					iResponse.sendError(404);// resource not found
					return;
				}
				
				// --- set content type
				String mimeType = iRequest.getParameter("mime-type");
				if(mimeType == null)
					mimeType = iRequest.getSession().getServletContext().getMimeType(resourcePath);
				if(mimeType == null)
					logger.warn("Unknown content type for resource '"+resourcePath+"'.");
				else
					iResponse.setContentType(mimeType);
				
//				System.out.println("--> serve resource "+requestUri.getPath());

				// --- set cache info
				long now = System.currentTimeMillis();
				iResponse.setDateHeader("Last-Modified", lastModified);
				iResponse.setDateHeader("Date", now);
				iResponse.setDateHeader("Expires", now + EXPIRATION_DELAY); // 1 hour
				
				// --- return file content
				OutputStream output = iResponse.getOutputStream();
				byte[] buffer = new byte[512];
				int len;
				while((len = input.read(buffer)) >= 0)
					output.write(buffer, 0, len);
				output.flush();
				output.close();
				input.close();
			}
			else
			{
				// --- unknown request type
				isHtml = false;// ???
			}
		}
		catch(Throwable t)
		{
			if(t instanceof InvocationTargetException)
				t = ((InvocationTargetException)t).getTargetException();
			
	    	if(isHtml)
	    	{
	    		// --- display error handler
	    		
				// --- place error in request
				iRequest.setAttribute("javax.servlet.error.exception", t);
				
				// --- forward to error handler page
				try
		        {
		            iRequest.getRequestDispatcher("/"+requestUri.getServlet()+"/"+BricksUrlBuilder.PAGE_SELECTOR+"/Error").forward(iRequest, iResponse);
		        }
		        catch(ServletException e)
		        {
		        	logger.error("Error dispatching to error page:", e);
		        }
				// --- remove error (otherwise complaints from the platform)
				iRequest.removeAttribute("javax.servlet.error.exception");
	    	}
	    	else
	    	{
	    		// --- HTTP error (internal server error)
		    	logger.error("Error:", t);
	    		iResponse.sendError(500);
	    	}
		}
		finally
		{
			// --- leave request
			BricksSessionImpl.exitRequest();
		}
	}

	// ====================================================================
	// === Bean Provider methods
	// ====================================================================
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlnode_0_unb_GlobalBeans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_GlobalBeans.length; i++)
		{
			Type t =_xmlnode_0_unb_GlobalBeans[i].getBeanGenericType(iName);
			if(t != null)
				return t;
		}
		return null;
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlnode_0_unb_GlobalBeans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_GlobalBeans.length; i++)
		{
			Class c =_xmlnode_0_unb_GlobalBeans[i].getBeanType(iName);
			if(c != null)
				return c;
		}
		return null;
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlnode_0_unb_GlobalBeans == null)
			return null;
		if(iName == null)
			return null;
		for(int i=0; i<_xmlnode_0_unb_GlobalBeans.length; i++)
		{
			Object o =_xmlnode_0_unb_GlobalBeans[i].getBeanValue(iRequest, iName);
			if(o != null)
				return o;
		}
		return null;
	}
	// ====================================================================
	// === Request Handler Management
	// ====================================================================
	private Hashtable<String, Object> _id2Handler = new Hashtable<String, Object>();
	private Hashtable<Object, String> _handler2Id = new Hashtable<Object, String>();
	
	public String registerRequestHandler(String iUniqueId, Object iHandler)
	{
		if(getHandler(iUniqueId) != null)
		{
			// --- proposed ID is free, register
			_id2Handler.put(iUniqueId, iHandler);
			_handler2Id.put(iHandler, iUniqueId);
			return null;
		}
		
		// --- look for a free ID
		int i=1;
		while(getHandler(iUniqueId+i) != null)
			i++;
		_id2Handler.put(iUniqueId+i, iHandler);
		_handler2Id.put(iHandler, iUniqueId+i);
		return iUniqueId+i;
	}
	private Object getHandler(String iId)
	{
		return _id2Handler.get(iId);
	}
	private String getHandlerId(Object iHandler)
	{
		return (String)_handler2Id.get(iHandler);
	}
	public String getHandlerParamName()
	{
		return HANDLER_PARAMNAME;
	}
	public String getHandlerParamValue(Object iHandler, String iMethod)
	{
		String handlerId = getHandlerId(iHandler);
		return handlerId+"."+iMethod;
	}
	public UrlBuilder createHandlerUrl(HttpServletRequest iRequest, Object iHandler, String iMethod)
	{
		// --- check whether this renderer has already been registered
		String handlerId = getHandlerId(iHandler);
		UrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
		url.setParameter(HANDLER_PARAMNAME, handlerId+"."+iMethod);
		return url;
	}
	public UrlBuilder createServiceUrl(HttpServletRequest iRequest, Object iHandler, String iMethod)
	{
		// --- check whether this renderer has already been registered
		String handlerId = getHandlerId(iHandler);
		BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, false);
		url.setSelector(BricksUrlBuilder.SERVICE_SELECTOR);
		url.setPath(handlerId+"/"+iMethod);
		return url;
	}

}
