package com.ebm_ws.infra.bricks.components.base.action;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.enums.AskBoxButtons;
import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.base.param.IUrlParameter;
import com.ebm_ws.infra.bricks.components.interfaces.IFrameContent;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Ask implements IXmlObject, IAction, IIdentifiable, IFrameContent
{
	private Application _xmlroot;
	
	private String _xmlattr_opt_ID;
	
	private String _xmlattr_opt_FrameName;
    private AskBoxButtons _xmlattr_req_Buttons;
    
    private IUrlParameter[] _xmlnode_0_unb_AddParameters;
	private IMessage _xmlnode_req_Title;
	private IMessage _xmlnode_req_Message;
	private IAction _xmlnode_req_OnYes;
	private IAction _xmlnode_req_OnNo;

//	private IUrlParameter[] _xmlnode_0_unb_AddParameters;
//	private IBinding _xmlnode_req_Do;
//	private Forward[] _xmlnode_1_unb_Forwards;
//	private IAction _xmlnode_opt_OnContinueAfterError;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		if(_xmlattr_opt_ID == null)
			return "AskBox";
		return "AskBox"+_xmlattr_opt_ID;
	}
	// --- [-] IIdentifiable implementation
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- register this component as a request handler
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
	}
	public String getURL(HttpServletRequest iRequest, boolean iEncodeHtml) throws Exception
	{
		// --- create callback url
			// TODO: mettre dans le contexte de la page courante (auto nettoy lorsqu'on en sort)
//			iRequest.getSession().setAttribute(this.getId()+".args", args);
		
		UrlBuilder url = _xmlroot.createHandlerUrl(iRequest, this, "invoke");
		if(_xmlnode_0_unb_AddParameters != null)
		{
			for(int i=0; i<_xmlnode_0_unb_AddParameters.length; i++)
				url.setParameter(_xmlnode_0_unb_AddParameters[i].getName(), String.valueOf(_xmlnode_0_unb_AddParameters[i].getValue(iRequest)));
		}
		return url.toUrl(iRequest.getCharacterEncoding(), iEncodeHtml);
	}
	/**
	 * Invoke the action: display the ask box page
	 */
	public void invoke(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if("POST".equals(iRequest.getMethod()))
		{
			// --- redirect after post
			iResponse.sendRedirect(getURL(iRequest, false));
			return;
		}
		
		// --- render askbox
		BricksSession session = BricksSession.getSession(iRequest);
		iRequest.setAttribute("_RENDER_PAGE_", this);
		
		IFrame frame = _xmlroot.getFrame(_xmlattr_opt_FrameName);
		// --- 1: pre-render
		frame.preRender(iRequest);
		
		// --- 2: render
		/*
		 * W3C rules:
		 * 
		 * XHTML 1.0 strict:
		 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
		 * <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
		 * 
		 * XHTML 1.0 transitional:
		 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		 * <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
		 * 
		 * HTML 4.0.1 strict:
		 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
		 * 
		 * HTML 4.0.1 transitional:
		 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
		 * <html lang="en">
		 * 
		 * XHTML 1.1:
		 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
		 * <html lang="en">
		 * 
		 * 
		 * With XHTML, the content type must be "application/xhtml+xml" or "text/xml" (for IE)
		 */
		// --- render response (html)
		iResponse.setContentType("text/html;charset="+session.getLocaleConfig().getCharSet());
//		iResponse.setHeader("Cache-Control", "no-store"); //HTTP 1.1
		iResponse.setHeader("Cache-Control", "no-cache"); //HTTP 1.1
		iResponse.setHeader("Pragma", "no-cache"); //HTTP 1.0
		iResponse.setDateHeader("Expires", 0); //prevents caching at the proxy server
		PrintWriter htmlWriter = iResponse.getWriter();
		
		// --- 3: render
		//TODO: other headers
		
		htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
		htmlWriter.print("<html lang=\"");
		htmlWriter.print(session.getLocaleConfig().getLocale().getLanguage());
		htmlWriter.println("\">");
		htmlWriter.println("<head>");

		// --- write page title
		htmlWriter.print("<title>");
		htmlWriter.print(HtmlUtils.encode2HTML(_xmlnode_req_Title.getMessage(iRequest)));
		htmlWriter.println("</title>");

		// --- meta tags
		// html content type
		htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset="+session.getLocaleConfig().getCharSet()+"'>");
		// no cache (for all browsers)
		htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
		htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
		htmlWriter.println("<meta http-equiv='expires' content='0'>");
		// --- les liens relatifs le sont par rapport  l'application
		htmlWriter.print("<base href='");
		htmlWriter.print(iRequest.getScheme());
		htmlWriter.print("://");
		htmlWriter.print(iRequest.getServerName());
		htmlWriter.print(":");
		htmlWriter.print(String.valueOf(iRequest.getServerPort()));
		htmlWriter.print(iRequest.getContextPath());
		htmlWriter.print("/");
		htmlWriter.println("'>");

		// --- import stylesheets
		CssStyleSheet[] styleSheets = frame.getStyleSheets();
		if(styleSheets != null)
		{
			for(int i=0; i<styleSheets.length; i++)
			{
				htmlWriter.print("<link rel='stylesheet' type='text/css' href='");
				htmlWriter.print(styleSheets[i].getFile());
				htmlWriter.println("'>");
			}
		}
		
		htmlWriter.println("</head>");
		
		htmlWriter.println("<body>");
		
		// --- render the frame
		frame.render(iRequest, iResponse);
		
		htmlWriter.println("</body>");
		htmlWriter.println("</html>");
		
		htmlWriter.flush();
		htmlWriter.close();
	}
	// ======================================================================
	// === IFrameContent
	// ======================================================================
	public String getFrameName()
	{
		return _xmlattr_opt_FrameName;
	}
	public String getTitle(HttpServletRequest request) throws Exception
	{
		return _xmlnode_req_Title.getMessage(request);
	}
	public void servePage(HttpServletRequest iRequest,HttpServletResponse iResponse) throws Exception
	{
		invoke(iRequest, iResponse);
	}
	public void preRender(HttpServletRequest request) throws Exception
	{
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		
		iWriter.println("<div id='askbox'>");
		iWriter.println("<p class='message'>");
		iWriter.println(HtmlUtils.encode2HTML(_xmlnode_req_Message.getMessage(iRequest)));
		iWriter.println("</p>");
		
		iWriter.print("<div class='Buttons'>");
		iWriter.print("<ul>");
		
		String yesUrl = _xmlnode_req_OnYes.getURL(iRequest, true);
		iWriter.print("<li>");
		iWriter.print("<a href='");
		iWriter.print(yesUrl);
		iWriter.print("'>");
		if(_xmlattr_req_Buttons == AskBoxButtons.OkCancel)
			iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.accept")));
		else
			iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.yes")));
		iWriter.print("</a>");
		iWriter.println("</li>");
		
		String cancelUrl = _xmlnode_req_OnNo.getURL(iRequest, true);
		iWriter.print("<li>");
		iWriter.print("<a href='");
		iWriter.print(cancelUrl);
		iWriter.print("'>");
		if(_xmlattr_req_Buttons == AskBoxButtons.OkCancel)
			iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.cancel")));
		else
			iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.no")));
		iWriter.print("</a>");
		iWriter.println("</li>");
		
		iWriter.print("</ul>");
		iWriter.println("</div>");

		iWriter.print("</ul>");
		iWriter.println("</div>");
	}
}
