package com.ebm_ws.infra.bricks.components.base.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.error.ErrorHandler;
import com.ebm_ws.infra.bricks.components.base.param.IUrlParameter;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class DoAndForward implements IXmlObject, IAction, IIdentifiable
{
	private static Log logger = LogFactory.getLog(DoAndForward.class);
	
	private Application _xmlroot;
	
	private String _xmlattr_opt_ID;
	
	private IUrlParameter[] _xmlnode_0_unb_AddParameters;
//	private ICallbackWithOutcome _xmlnode_req_Do;
	private IBinding _xmlnode_req_Do;
	private Case[] _xmlnode_1_unb_Forwards;
	private IAction _xmlnode_opt_OnContinueAfterError;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		if(_xmlattr_opt_ID == null)
			return "DnF";
		return "DnF_"+_xmlattr_opt_ID;
	}
	// --- [-] IIdentifiable implementation
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- register this component as a request handler
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        
        // --- in case of multiple forwards, check that the execute returns a String object
        if(_xmlnode_1_unb_Forwards != null && _xmlnode_1_unb_Forwards.length > 1 && !_xmlnode_req_Do.hasErrors())
        {
        	if(!String.class.equals(_xmlnode_req_Do.getType()))
        	{
            	iErrors.logMessage(this, "Do", IValidityLogger.ERROR, "The callback action must return a String value (corresponding to the selected forward to follow).");
        	}
        }
	}
	public String getURL(HttpServletRequest iRequest, boolean iEncodeHtml) throws Exception
	{
		// --- create callback url
			// TODO: mettre dans le contexte de la page courante (auto nettoy lorsqu'on en sort)
//			iRequest.getSession().setAttribute(this.getId()+".args", args);
		
		UrlBuilder url = _xmlroot.createHandlerUrl(iRequest, this, "invoke");
		if(_xmlnode_0_unb_AddParameters != null)
		{
			for(int i=0; i<_xmlnode_0_unb_AddParameters.length; i++)
				url.setParameter(_xmlnode_0_unb_AddParameters[i].getName(), String.valueOf(_xmlnode_0_unb_AddParameters[i].getValue(iRequest)));
		}
		return url.toUrl(iRequest.getCharacterEncoding(), iEncodeHtml);
	}
	public void invoke(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		// --- execute callback and select outcome
		try
		{
			Object ret = _xmlnode_req_Do.invoke(iRequest);
			if(ret == null)
			{
				// assume default one is the first one
				_xmlnode_1_unb_Forwards[0]._xmlcollect_req_Action.invoke(iRequest, iResponse);
				return;
			}
			
			String fwdName = (String)ret;
			for(int i=0; i<_xmlnode_1_unb_Forwards.length; i++)
			{
				if(fwdName.equals(_xmlnode_1_unb_Forwards[i].getName()))
				{
					// --- forward found: invoke
					_xmlnode_1_unb_Forwards[i]._xmlcollect_req_Action.invoke(iRequest, iResponse);
					return;
				}
			}
			// --- forward not found
			logger.error("Action Handler "+_xmlnode_req_Do+" returned and unknown forward name: "+fwdName);
			return;
		}
		catch(Exception e)
		{
			// --- an invocation has generated an exception
			if(_xmlnode_opt_OnContinueAfterError != null)
			{
				// --- the error handler will display the exception
				// --- we have to pass it the nextUrl
				ErrorHandler.setNextUrl(iRequest, _xmlnode_opt_OnContinueAfterError.getURL(iRequest, false));
			}
			
			throw e;
		}
	}
}
