package com.ebm_ws.infra.bricks.components.base.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.xmlmapping.interfaces.IXmlSubstitutionGroup;

/**
 * An action is a piece of logic that handles events, and reacts by navigating
 * to another view.
 * Actions might be either trigger by direct navigation, or invoked by code.
 * @author crhx7117
 */
public interface IAction extends IXmlSubstitutionGroup
{
	/**
	 * Returns an url that causes the action to be triggered when navigated.
	 * @param iRequest
	 * @return the action trigger url.
	 * @throws Exception
	 */
	String getURL(HttpServletRequest iRequest, boolean iEncodeHtml) throws Exception;
	
	/**
	 * Invokes the action and returns the outcome url.
	 * @param iRequest
	 * @return the action outcome url.
	 * @throws Exception
	 */
	void invoke(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception;

}
