package com.ebm_ws.infra.bricks.components.base.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.base.page.ctx.IPageContextDef;
import com.ebm_ws.infra.bricks.components.base.param.IUrlParameter;
import com.ebm_ws.infra.bricks.components.base.param.UrlParameterDef;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class ShowPage implements IXmlObject, IAction
{
	private Application _xmlancestor_app;
	private IPage _xmlancestor_page;
	private boolean _inSameContext = false;
	private String _xmlattr_req_Page;
	private IUrlParameter[] _xmlnode_0_unb_Parameters;

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		IPage refPage = _xmlancestor_app.getPage(_xmlattr_req_Page);
		if(refPage == null)
		{
			iErrors.logMessage(this, "Page", IValidityLogger.ERROR, "Page '"+_xmlattr_req_Page+"' not found.");
		}
		else
		{
			// --- determine whether this is an action that stays in the same page context or not
			if(_xmlancestor_page != null)
			{
				_inSameContext = _xmlancestor_page.getContextDef().equals(refPage.getContextDef());
//				System.out.println("ShowPage("+_xmlattr_req_Page+") from page ["+_xmlancestor_page.getName()+"] is same context: "+_inSameContext);
			}
			
			if(!_inSameContext)
			{
				// --- check that all required parameters are passed to the target page
				IPageContextDef refContext = refPage.getContextDef();
				// --- check arguments
				List<UrlParameterDef> inputArgs = null;
				if(refContext.getInputParameters() != null && refContext.getInputParameters().length > 0)
				{
					inputArgs = new ArrayList<UrlParameterDef>();
					for(int i=0; i<refContext.getInputParameters().length; i++)
						inputArgs.add(refContext.getInputParameters()[i]);
				}
				
				// --- vrifier si les arguments sont de type simple ou non, et s'ils correspondent aux arguments requis par la page (TODO)
				if(_xmlnode_0_unb_Parameters != null)
				{
					if(inputArgs != null)
					{
						// --- check that required args are passed, and that every arg matches one of the page args (name and type)
						for(int i=0; i<_xmlnode_0_unb_Parameters.length; i++)
						{
							String argName = _xmlnode_0_unb_Parameters[i].getName();
							// --- does it match to one of the input args?
							int j=0;
							while(j<inputArgs.size() && !argName.equals(inputArgs.get(j).getName()))
								j++;
							if(j<inputArgs.size())
							{
//								UrlParameterDef argDef = inputArgs.get(j);
								// --- arg was found: check that type matches
		// TODO?						if(!type.isAssignableFrom(argDef.getType()))
		//							iErrors.logMessage(this, "Args", IValidityLogger.ERROR, "Argument '"+argName+"' type does not match input page argument type.");
								// --- remove input arg
								inputArgs.remove(j);
							}
							else
							{
								// --- arg not found: info
								iErrors.logMessage(this, "Parameters", IValidityLogger.INFO, "Argument '"+argName+"' does not match to any input page argument.");
							}
						}
					}
				}
				if(inputArgs != null)
				{
					// --- log remaining args
					for(int i=0; i<inputArgs.size(); i++)
					{
						UrlParameterDef argDef = inputArgs.get(i);
						iErrors.logMessage(this, "Parameters", IValidityLogger.WARNING, "Parameter '"+argDef.getName()+"' from page '"+_xmlattr_req_Page+"' is not sent.");
					}
				}
			}
		}
	}
	public String getURL(HttpServletRequest iRequest, boolean iEncodeHtml) throws Exception
	{
		BricksUrlBuilder url = BricksUrlBuilder.createPageUrl(iRequest, _xmlattr_req_Page, _inSameContext);
		if(_xmlnode_0_unb_Parameters != null)
		{
			for(int i=0; i<_xmlnode_0_unb_Parameters.length; i++)
				url.setParameter(_xmlnode_0_unb_Parameters[i].getName(), _xmlnode_0_unb_Parameters[i].getValue(iRequest));
		}
		return url.toUrl(iRequest.getCharacterEncoding(), iEncodeHtml);
	}
	public void invoke(HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		// --- redirect to the url
		response.sendRedirect(getURL(request, false));
	}
}
