package com.ebm_ws.infra.bricks.components.base.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class SwitchAction implements IXmlObject, IAction
{
	private static Log logger = LogFactory.getLog(SwitchAction.class);
	
	private IBinding _xmlnode_req_Switch;
	private Case[] _xmlnode_1_unb_Cases;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
        // --- in case of multiple forwards, check that the execute returns a String object
        if(_xmlnode_1_unb_Cases != null && _xmlnode_1_unb_Cases.length > 1)
        {
        	if(!String.class.equals(_xmlnode_req_Switch.getType()))
        	{
            	iErrors.logMessage(this, "Switch", IValidityLogger.ERROR, "The callback action must return a String value (corresponding to the selected forward to follow).");
        	}
        }
	}
	public String getURL(HttpServletRequest iRequest, boolean iEncodeHtml) throws Exception
	{
		// --- execute callback and select outcome
		Object ret = _xmlnode_req_Switch.invoke(iRequest);
		if(ret == null)
		{
			return null;
		}
		
		String fwdName = (String)ret;
		for(int i=0; i<_xmlnode_1_unb_Cases.length; i++)
		{
			if(fwdName.equals(_xmlnode_1_unb_Cases[i].getName()))
			{
				// --- forward found: invoke
//				return _xmlnode_1_unb_Forwards[i].getUrl(iRequest);
				return _xmlnode_1_unb_Cases[i]._xmlcollect_req_Action.getURL(iRequest, iEncodeHtml);
			}
		}
		// --- forward not found
		logger.info("Action Handler "+_xmlnode_req_Switch+" returned and unknown forward name: "+fwdName);
		return null;
	}
	public void invoke(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		// --- execute callback and select outcome
		Object ret = _xmlnode_req_Switch.invoke(iRequest);
		if(ret == null)
		{
			// --- stay here: redirect after post?
			return;
		}
		
		String fwdName = (String)ret;
		for(int i=0; i<_xmlnode_1_unb_Cases.length; i++)
		{
			if(fwdName.equals(_xmlnode_1_unb_Cases[i].getName()))
			{
				// --- forward found: invoke
//				return _xmlnode_1_unb_Forwards[i].getUrl(iRequest);
				_xmlnode_1_unb_Cases[i]._xmlcollect_req_Action.invoke(iRequest, iResponse);
				return;
			}
		}
		// --- forward not found
		logger.info("Action Handler "+_xmlnode_req_Switch+" returned and unknown forward name: "+fwdName);
		// --- stay here: redirect after post?
		return;
	}
}
