package com.ebm_ws.infra.bricks.components.base.binding;

import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.enums.Scope;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider.UnresolvedBeanError;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Bean implements IXmlObject
{
	private static Class[] DEFAULT_CONSTR = {};
	
	private String _xmlattr_req_Name;
	private Scope _xmlattr_req_LifeScope;
	private String _xmlattr_req_Class;
	private Class _class;
	private boolean initialized = false;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		try
        {
			// --- retreive bean class
	        _class = Class.forName(_xmlattr_req_Class);
        }
        catch(ClassNotFoundException e)
        {
        	iErrors.logMessage(this, "Class", IValidityLogger.ERROR, "Bean Class '"+_xmlattr_req_Class+"' not found.");
        }
        
        if(_class != null)
        {
	        // --- check that class has a default constructor
	        try
            {
	            _class.getConstructor(DEFAULT_CONSTR);
            }
            catch(Exception e)
            {
            	iErrors.logMessage(this, "Class", IValidityLogger.WARNING, "Bean Class '"+_xmlattr_req_Class+"' has no default constructor. Won't be able to instanciate.");
            }
        }
	}
	public String getName()
	{
		return _xmlattr_req_Name;
	}
	public Type getGenericType() throws UnresolvedBeanError
	{
	    return getType();
	}
	public Class getType() throws UnresolvedBeanError
	{
		// --- !!! may be called before init !!!
		if(!initialized)
		{
			initialized = true;
			try
	        {
		        _class = Class.forName(_xmlattr_req_Class);
	        }
	        catch(ClassNotFoundException e)
	        {
	        }
		}
		if(_class == null)
			throw new UnresolvedBeanError();
		return _class;
	}
	public Object getObject(HttpServletRequest iRequest) throws Exception
	{
		// --- 1: get from cache
		Object obj = null;
		if(_xmlattr_req_LifeScope == Scope.Request)
		{
			obj = iRequest.getAttribute(getName());
		}
		else if(_xmlattr_req_LifeScope == Scope.Session)
		{
			obj = iRequest.getSession().getAttribute(getName());
		}
		else if(_xmlattr_req_LifeScope == Scope.Application)
		{
			obj = iRequest.getSession().getServletContext().getAttribute(getName());
		}
		else if(_xmlattr_req_LifeScope == Scope.PageContext)
		{
			BricksSession session = BricksSession.getSession(iRequest);
			obj = session.getCurrentPageContext().getAttribute(getName());
		}
		
		if(obj == null)
		{
			// --- 2: instanciate and put in cache
			obj = _class.newInstance();
			
			if(_xmlattr_req_LifeScope == Scope.Request)
			{
				iRequest.setAttribute(getName(), obj);
			}
			else if(_xmlattr_req_LifeScope == Scope.Session)
			{
				iRequest.getSession().setAttribute(getName(), obj);
			}
			else if(_xmlattr_req_LifeScope == Scope.Application)
			{
				iRequest.getSession().getServletContext().setAttribute(getName(), obj);
			}
			else if(_xmlattr_req_LifeScope == Scope.PageContext)
			{
				BricksSession session = BricksSession.getSession(iRequest);
				session.getCurrentPageContext().setAttribute(getName(), obj);
			}
		}
		
		return obj;
	}

}
