package com.ebm_ws.infra.bricks.components.base.binding;

import java.lang.reflect.Type;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.ExpressionCompiler;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext.UnresolvedObjectError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.ParseError;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Expression extends BaseBeanProvider implements IXmlObject, IBinding
{
//	private Application _xmlroot;
//	private IDynBeanProvider _xmlancestor_dynprovider;
	private String _xmlcontent;
	private String _id;
	private IEvaluable _evaluable;
	private String _compilationError;
	
	private void initialize()
	{
		if(_evaluable == null && _compilationError == null)
		{
			_xmlcontent = _xmlcontent.trim();
			ExpressionCompiler compiler = new ExpressionCompiler(_xmlcontent);
			try
	        {
		        _evaluable = compiler.compile(new CompilationContext());
	        }
	        catch(ParseError e)
	        {
	        	_compilationError = e.getMessage();
	        }
            catch(UnresolvedObjectError e)
            {
            	// --- errors correlation: the expression could not be compiled because a referenced object had problems
            	// do not mention...
            }
		}
	}
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		initialize();
		
		if(_compilationError != null)
			iErrors.logMessage(this, "content", IValidityLogger.ERROR, _compilationError);
	}
	public Type getGenericType()
	{
		initialize();
		if(_evaluable == null)
			return null;
	    return _evaluable.getGenericType();
	}
	public Class getType()
	{
		initialize();
		if(_evaluable == null)
			return null;
	    return _evaluable.getType();
	}
	public boolean hasErrors()
	{
		initialize();
	    return _compilationError != null;
	}
	public Object invoke(HttpServletRequest iRequest) throws Exception
	{
		return _evaluable.evaluate(new ExecutionContext(iRequest));
	}
	public String getID()
	{
		if(_id == null)
			_id = HtmlUtils.formatId(_xmlcontent);
	    return _id;
	}
	public boolean isGetSet()
	{
	    return _evaluable.isGetSet();
	}
	public void setValue(HttpServletRequest iRequest, Object iValue) throws Exception
	{
		_evaluable.set(new ExecutionContext(iRequest), iValue);
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if("request".equals(iName))
			return HttpServletRequest.class;
        if("locale".equals(iName))
            return Locale.class;

	    return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if("request".equals(iName))
			return HttpServletRequest.class;
        if("locale".equals(iName))
            return Locale.class;

	    return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if("request".equals(iName))
			return iRequest;
        if("locale".equals(iName))
            return BricksSession.getSession(iRequest).getLocale();
		
	    return getParentBeanValue(iRequest, iName);
	}
	@Override
	public String toString()
	{
		return "Expression("+_xmlcontent+")";
	}
	// ==============================================================================
	// === Compilation context
	// ==============================================================================
	private class CompilationContext implements ICompilationContext
	{
		public Type getObjectGenericType(String iName) throws UnresolvedObjectError
		{
			try
            {
	            return getBeanGenericType(iName);
            }
            catch(UnresolvedBeanError e)
            {
            	throw new UnresolvedObjectError();
            }
		}
		public Class getObjectType(String iName) throws UnresolvedObjectError
		{
			try
            {
	            return getBeanType(iName);
            }
            catch(UnresolvedBeanError e)
            {
            	throw new UnresolvedObjectError();
            }
		}
	}
	// ==============================================================================
	// === Compilation context
	// ==============================================================================
	private class ExecutionContext implements IExecutionContext
	{
		private HttpServletRequest request;
		
		public ExecutionContext(HttpServletRequest iRequest)
		{
			request = iRequest;
		}
		public Object getObject(String iName) throws Exception
		{
			return getBeanValue(request, iName);
		}
	}

}
