package com.ebm_ws.infra.bricks.components.base.binding;

import java.lang.reflect.Type;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class JavaBeans implements IXmlObject, IDataSource
{
	// --- data sources (beans)
	private Bean[] _xmlcollect_1_unb_Beans;
	private HashMap<String, Bean> _name2Bean;
	
	public void checkThisNode(Object validSupport, IValidityLogger errors)
	{
		init();
		
		// --- check beans don't have the same name
		if(_xmlcollect_1_unb_Beans != null)
		{
			HashMap<String, Bean> name2Bean = new HashMap<String, Bean>();
			for(int i=0; i<_xmlcollect_1_unb_Beans.length; i++)
			{
				if(_xmlcollect_1_unb_Beans[i] == null)
					continue;
				if(_xmlcollect_1_unb_Beans[i].getName() == null)
					continue;
				if(name2Bean.get(_xmlcollect_1_unb_Beans[i].getName()) != null)
					errors.logMessage((IXmlObject)_xmlcollect_1_unb_Beans[i], "Beans", IValidityLogger.ERROR, "More than one bean with name '"+_xmlcollect_1_unb_Beans[i].getName()+"'.");
				else
					name2Bean.put(_xmlcollect_1_unb_Beans[i].getName(), _xmlcollect_1_unb_Beans[i]);
			}
		}
	}
	private void init()
	{
		if(_name2Bean == null)
		{
			_name2Bean = new HashMap<String, Bean>();
			if(_xmlcollect_1_unb_Beans != null)
			{
				for(int i=0; i<_xmlcollect_1_unb_Beans.length; i++)
					_name2Bean.put(_xmlcollect_1_unb_Beans[i].getName(), _xmlcollect_1_unb_Beans[i]);
			}
		}
	}
	public Class getBeanType(String name) throws UnresolvedBeanError
	{
		if(_name2Bean == null)
			init();
		Bean bean = _name2Bean.get(name);
		if(bean == null)
			return null;
		return bean.getType();
	}
	public Type getBeanGenericType(String name) throws UnresolvedBeanError
	{
		if(_name2Bean == null)
			init();
		Bean bean = _name2Bean.get(name);
		if(bean == null)
			return null;
		return bean.getGenericType();
	}
	public Object getBeanValue(HttpServletRequest request, String name) throws Exception
	{
		if(_name2Bean == null)
			init();
		Bean bean = _name2Bean.get(name);
		if(bean == null)
			return null;
		return bean.getObject(request);
	}
}
