package com.ebm_ws.infra.bricks.components.base.binding.expressions;

import java.lang.reflect.Type;

public interface IEvaluable
{
	/**
	 * Evaluates the expression.
	 */
	Object evaluate(IExecutionContext iContext) throws Exception;
	
	/**
	 * Returns the returned type
	 */
	Class getType();
	
	/**
	 * Returns the returned generic type
	 */
	Type getGenericType();
	
	/**
	 * Determines whether this expression can be get and set
	 * @return
	 */
	boolean isGetSet();
	
	/**
	 * Assigns a value to this expression (if supported)
	 */
	void set(IExecutionContext iContext, Object iValue) throws Exception;
	
	String getExpression();
}
