package com.ebm_ws.infra.bricks.components.base.binding.expressions;

import java.lang.reflect.Type;

import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;

public class Test
{

	/**
	 * @param args
	 * @throws Throwable 
	 */
	public static void main(String[] args) throws Throwable
	{
		Context ctx = new Context();
		ctx.put("array1", new String[]{"aaa", "bbb", "ccc"});
		ctx.put("array2", new int[]{1, 2, 3, 4, 5, 6});
		ctx.put("str", "Oh la belle string!");

//		Expression compiler = new Expression("str.bytes[3]");
		ExpressionCompiler compiler = new ExpressionCompiler("['coucou', str]");
		IEvaluable eval = compiler.compile(ctx);
		System.out.println("Result: "+eval.evaluate(ctx));
	}
	public static class Context implements ICompilationContext, IExecutionContext
	{
		private Hashtable objects = new Hashtable();
		
		public void put(String iName, Object iValue)
		{
			objects.put(iName, iValue);
		}
		
		public Object getObject(String iName)
		{
		    return objects.get(iName);
		}
		public Type getObjectGenericType(String iName)
		{
		    return getObjectType(iName);
		}
		public Class getObjectType(String iName)
		{
			Object o = getObject(iName);
			if (o == null)
				return null;
		    return o.getClass();
		}
	}

}
