package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;

public class ArrayObj implements IEvaluable
{
	private IEvaluable[] elements;
	private Class arrayCompType;
	private Object arrayPrototype;
	
	public ArrayObj(ICompilationContext iContext, IEvaluable[] iElements) throws CompilationError
	{
		elements = iElements;
		
		// --- determine best component type
		arrayCompType = Object.class;
		if(iElements != null && iElements.length > 0)
		{
			arrayCompType = iElements[0].getType();
			for(int i=1; i<iElements.length; i++)
			{
				while(!iElements[i].getType().isAssignableFrom(arrayCompType))
				{
					arrayCompType = arrayCompType.getSuperclass();
					if(arrayCompType == Object.class)
						break;
				}
			}
		}
		
		arrayPrototype = Array.newInstance(arrayCompType, 0);
	}
	public Object evaluate(IExecutionContext iContext) throws Exception
	{
		Object array = Array.newInstance(arrayCompType, elements.length);
		for(int i=0; i<elements.length; i++)
			Array.set(array, i, elements[i].evaluate(iContext));
	    return array;
	}
	public Class getType()
	{
		return arrayPrototype.getClass();
	}
	public Type getGenericType()
	{
		return arrayPrototype.getClass();
	}
	public void set(IExecutionContext iContext, Object iValue) throws Exception
	{
		//TODO: throw an exception?
	}
	public boolean isGetSet()
	{
	    return false;
	}
	public String getExpression()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("[");
		if(elements != null)
		{
			for(int i=0; i<elements.length; i++)
			{
				if(i > 0)
					sb.append(", ");
				sb.append(elements[i].getExpression());
			}
		}
		sb.append("]");
	    return sb.toString();
	}
	public String toString()
	{
		return "Expression: "+getExpression();
	}
}
