package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;

public class Attribute implements IEvaluable
{
	private static Object[] NO_ARG = new Object[]{};
	private static Class[] GET_SIGNATURE = {};
	
	private IEvaluable object;
	private String attrName;
	private Method get;
	private Method set;
	
	public Attribute(ICompilationContext iContext, String iName, IEvaluable iObject) throws CompilationError
	{
		object = iObject;
		attrName = iName;
		Class objType = iObject.getType();
		
		// --- look for get method
		String getMethodName = "get"+(Character.toUpperCase(attrName.charAt(0)))+(attrName.substring(1));
		try
        {
            get = objType.getMethod(getMethodName, GET_SIGNATURE);
        }
        catch(Exception e)
        {
        	// --- try the is<attribute> signature (for a boolean only)
        	String isMethodName = "is"+(Character.toUpperCase(attrName.charAt(0)))+(attrName.substring(1));
    		try
            {
                get = objType.getMethod(isMethodName, GET_SIGNATURE);
                
                // --- method found: return type must be boolean (with this signature)
                if(get.getReturnType() != Boolean.class && get.getReturnType() != Boolean.TYPE)
                {
        			throw new CompilationError("The 'is' getter signature is only allowed for boolean type attributes.");
                }
            }
            catch(Exception e1)
            {
    			throw new CompilationError("No such attribute: '"+attrName+"' (neither "+getMethodName+" nor "+isMethodName+" on object "+objType.getName()+").", e);
            }
        }
		// --- test method can be accessed
		if((get.getModifiers() & Modifier.PUBLIC) == 0)
			throw new CompilationError("Get method not public: "+get);

        // --- now look for set method
		String setMethodName = "set"+(Character.toUpperCase(attrName.charAt(0)))+(attrName.substring(1));
       	try
        {
	        set = objType.getMethod(setMethodName, new Class[]{get.getReturnType()});
        }
        catch(Exception e)
        {
        	// --- nevermind
        }
		if(set != null && (set.getModifiers() & Modifier.PUBLIC) == 0)
			// --- set method not accessible (Warning ?)
			set = null;
	}
	public Object evaluate(IExecutionContext iContext) throws Exception
	{
		Object obj = object.evaluate(iContext);
		try
		{
			return get.invoke(obj, NO_ARG);
		}
		catch(InvocationTargetException e)
		{
			// --- exception sent by the invoked method: rethrow
        	if(e.getTargetException() instanceof Exception)
        		throw (Exception)e.getTargetException();
        	if(e.getTargetException() instanceof Error)
        		throw (Error)e.getTargetException();
			throw e;
		}
		catch(Exception e)
		{
			throw new Exception("Error while getting Attribute: "+getExpression(), e);
		}
	}
	public Type getGenericType()
	{
	    return get.getGenericReturnType();
	}
	public Class getType()
	{
	    return get.getReturnType();
	}
	public boolean isGetSet()
	{
	    return set != null;
	}
	public void set(IExecutionContext iContext, Object iValue) throws Exception
	{
		if(set == null)
			return;
		Object obj = object.evaluate(iContext);
		try
		{
			// --- manage primitive types with null value
			if(iValue == null && get.getReturnType().isPrimitive())
			{
				if(get.getReturnType() == Integer.TYPE)
					iValue = 0;
				else if(get.getReturnType() == Short.TYPE)
					iValue = 0;
				else if(get.getReturnType() == Long.TYPE)
					iValue = 0;
				else if(get.getReturnType() == Boolean.TYPE)
					iValue = true;
			}
			set.invoke(obj, new Object[]{iValue});
		}
		catch(InvocationTargetException e)
		{
        	if(e.getTargetException() instanceof Exception)
        		throw (Exception)e.getTargetException();
        	if(e.getTargetException() instanceof Error)
        		throw (Error)e.getTargetException();
			throw e;
		}
		catch(Exception e)
		{
			throw new Exception("Error while setting Attribute: "+getExpression(), e);
		}
	}
	public String getExpression()
	{
		return object.getExpression()+"."+attrName;
	}
	public String toString()
	{
		return "Expression: "+getExpression();
	}

}
