package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;

public class Braces implements IEvaluable
{
	private IEvaluable object;
	private IEvaluable item;
	private Class returnClass;
	private Type returnType;
	
	public Braces(ICompilationContext iContext, IEvaluable iObject, IEvaluable iItem) throws CompilationError
	{
		object = iObject;
		item = iItem;
		Type objType = iObject.getGenericType();
		Class objClass = iObject.getType();
		Class itemClass = item.getType();
		if(objClass.isArray())
		{
			// --- item must be of type int
			if(!Integer.class.isAssignableFrom(itemClass) && !Integer.TYPE.isAssignableFrom(itemClass))
				throw new CompilationError("Brace argument must be either int or Integer.");
			returnClass = objClass.getComponentType();
			returnType = returnClass;
			if(objType instanceof GenericArrayType)
				returnType = ((GenericArrayType)objType).getGenericComponentType();
		}
		else if(List.class.isAssignableFrom(objClass))
		{
			// --- item must be of type int
			if(!Integer.class.isAssignableFrom(itemClass) && !Integer.TYPE.isAssignableFrom(itemClass))
				throw new CompilationError("Brace argument must be either int or Integer.");
			
			returnType = Object.class;
			returnClass = Object.class;
			
			if(objType instanceof ParameterizedType)
			{
				returnType = ((ParameterizedType)objType).getActualTypeArguments()[0];
				
				if(returnType instanceof Class)
					returnClass = (Class)returnType;
				else if(returnType instanceof ParameterizedType)
					returnClass = (Class)((ParameterizedType)returnType).getRawType();
			}
		}
		else if(Map.class.isAssignableFrom(objClass))
		{
			// --- item can be of any type
			returnType = Object.class;
			returnClass = Object.class;
			if(objType instanceof ParameterizedType)
			{
				// --- get return type
				returnType = ((ParameterizedType)objType).getActualTypeArguments()[1];
				
				// --- check item type
				Class declaredItemClass = null;
				Type declaredItemType = ((ParameterizedType)objType).getActualTypeArguments()[0];
				if(declaredItemType instanceof Class)
					declaredItemClass = (Class)declaredItemType;
				else if(declaredItemType instanceof ParameterizedType)
					declaredItemClass = (Class)((ParameterizedType)declaredItemType).getRawType();

				if(declaredItemClass != null && !declaredItemClass.isAssignableFrom(itemClass))
					throw new CompilationError("Brace argument must be of type "+declaredItemClass.getName()+".");
				
				// --- get precise return class
				if(returnType instanceof Class)
					returnClass = (Class)returnType;
				else if(returnType instanceof ParameterizedType)
					returnClass = (Class)((ParameterizedType)returnType).getRawType();
			}
		}
		else
		{
			throw new CompilationError("Object type does not support [] access: "+objClass.getName());
		}
	}
	public Object evaluate(IExecutionContext iContext) throws Exception
	{
		Object obj = object.evaluate(iContext);
		Object arg = item.evaluate(iContext);
		
		if(obj.getClass().isArray())
		{
			// --- item must be of type int.
			int index = 0;
			if(arg instanceof Integer)
				index = ((Integer)arg).intValue();
			else if(arg instanceof Long)
				index = ((Long)arg).intValue();
			else
				throw new Exception("Argument not an int: "+arg);
			
			return Array.get(obj, index);
		}
		else if(obj instanceof List)
		{
			// --- item must be of type int
			int index = 0;
			if(arg instanceof Integer)
				index = ((Integer)arg).intValue();
			else if(arg instanceof Long)
				index = ((Long)arg).intValue();
			else
				throw new Exception("Argument not an int: "+arg);
			
			return ((List)obj).get(index);
		}
		else if(obj instanceof Map)
		{
			// --- item can be of any type
			return ((Map)obj).get(item);
		}
		else
		{
			throw new Exception("Object type does not support []: "+object.getClass().getName());
		}
	}
	public Class getType()
	{
		return returnClass;
	}
	public Type getGenericType()
	{
	    return returnType;
	}
	public void set(IExecutionContext iContext, Object iValue) throws Exception
	{
		//TODO?
	}
	public boolean isGetSet()
	{
		//TODO?
	    return false;
	}
	public String getExpression()
	{
		StringBuilder sb = new StringBuilder();
		sb.append(object.getExpression());
		sb.append("[");
		sb.append(item.getExpression());
		sb.append("]");
	    return sb.toString();
	}
	public String toString()
	{
		return "Expression: "+getExpression();
	}
}
