package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.lang.reflect.Type;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext.UnresolvedObjectError;

public class GlobalVar implements IEvaluable
{
	private String varName;
	private Class varClass;
	private Type varType;
	
	public GlobalVar(ICompilationContext iContext, String iName) throws CompilationError, UnresolvedObjectError
	{
		varName = iName;
		varClass = iContext.getObjectType(varName);
		varType = iContext.getObjectGenericType(varName);
		if(varType == null)
			throw new CompilationError("No such object: '"+varName+"'.");
	}
	public Object evaluate(IExecutionContext iContext) throws Exception
	{
		try
		{
			return iContext.getObject(varName);
		}
		catch(Exception e)
		{
			throw new Exception("Error while retrieving GlobalVar: "+getExpression(), e);
		}
	}
	public Class getType()
	{
		return varClass;
	}
	public Type getGenericType()
	{
	    return varType;
	}
	public void set(IExecutionContext iContext, Object iValue) throws Exception
	{
		//TODO: throw an exception?
	}
	public boolean isGetSet()
	{
	    return false;
	}
	public String getExpression()
	{
	    return varName;
	}
	public String toString()
	{
		return "Expression: "+getExpression();
	}
}
