package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;

public class Method implements IEvaluable
{
	private IEvaluable object;
	private IEvaluable[] arguments;
	private String methodName;
	private java.lang.reflect.Method method;
	
	public Method(ICompilationContext iContext, String iName, IEvaluable iObject, IEvaluable[] iArgs) throws CompilationError
	{
		object = iObject;
		arguments = iArgs;
		methodName = iName;
		Class objType = iObject.getType();
		
		// --- get arguments type
		Class[] argTypes = new Class[arguments.length];
		for(int i=0; i<arguments.length; i++)
			argTypes[i] = arguments[i].getType();
		
		// --- 1: look for method with exact argument types
		try
		{
			method = objType.getMethod(methodName, argTypes);
		}
		catch (Exception e)
		{
		}
		
		// --- 2: look for method with compatible argument types
		if(method == null)
		{
	//		java.lang.reflect.Method[] methods = objType.getDeclaredMethods();
	        java.lang.reflect.Method[] methods = objType.getMethods();
			for(int i=0; i<methods.length; i++)
			{
				if(methods[i].getName().equals(iName))
				{
					// --- check arguments
					if(methods[i].getParameterTypes().length == argTypes.length)
					{
						method = methods[i];
						
						for(int j=0; j<argTypes.length; j++)
						{
							Class paramClass = methods[i].getParameterTypes()[j];
							if(!ReflectionHelper.isAssignable(paramClass, argTypes[j]))
							{
								// --- does not match
								method = null;
								break;
							}
						}
						if(method != null)
							break;
					}
				}
			}
		}
		
		// --- if no method found: throw an exception
		if(method == null)
		{
			StringBuilder sb = new StringBuilder();
			sb.append("No such method: ");
			sb.append(objType.getName());
			sb.append(".");
			sb.append(methodName);
			sb.append("(");
			for(int i=0; i<argTypes.length; i++)
			{
				if(i > 0)
					sb.append(", ");
				sb.append(argTypes[i].getName());
			}
			sb.append(")");
			throw new CompilationError(sb.toString());
		}
		// --- test method can be accessed
		if((method.getModifiers() & Modifier.PUBLIC) == 0)
			throw new CompilationError("Method not public: "+method);
	}
	public Object evaluate(IExecutionContext iContext) throws Exception
	{
		Object obj = object.evaluate(iContext);
		Object[] args = new Object[arguments.length];
		for(int i=0; i<arguments.length; i++)
			args[i] = arguments[i].evaluate(iContext);
		try
		{
			return method.invoke(obj, args);
		}
		catch(InvocationTargetException e)
		{
        	if(e.getTargetException() instanceof Exception)
        		throw (Exception)e.getTargetException();
        	if(e.getTargetException() instanceof Error)
        		throw (Error)e.getTargetException();
			throw e;
		}
		catch(Exception e)
		{
			throw new Exception("Error while invoking Method: "+getExpression(), e);
		}
	}
	public Type getGenericType()
	{
	    return method.getGenericReturnType();
	}
	public Class getType()
	{
	    return method.getReturnType();
	}
	public void set(IExecutionContext iContext, Object iValue) throws Exception
	{
		//TODO: throw an exception?
	}
	public boolean isGetSet()
	{
	    return false;
	}
	public String getExpression()
	{
		StringBuilder sb = new StringBuilder();
		sb.append(object.getExpression());
		sb.append(".");
		sb.append(methodName);
		sb.append("(");
		if(arguments != null)
		{
			for(int i=0; i<arguments.length; i++)
			{
				if(i > 0)
					sb.append(", ");
				sb.append(arguments[i].getExpression());
			}
		}
		sb.append(")");
	    return sb.toString();
	}
	public String toString()
	{
		return "Expression: "+getExpression();
	}
}
