package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.lang.reflect.Type;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;

public class StaticObj implements IEvaluable
{
	private Object object;
	
	public StaticObj(ICompilationContext iContext, Object iObj) throws CompilationError
	{
		object = iObj;
	}
	public Object evaluate(IExecutionContext iContext)
	{
	    return object;
	}
	public Class getType()
	{
		return object.getClass();
	}
	public Type getGenericType()
	{
	    return object.getClass();
	}
	public void set(IExecutionContext iContext, Object iValue) throws Exception
	{
		//TODO: throw an exception?
	}
	public boolean isGetSet()
	{
	    return false;
	}
	public String getExpression()
	{
	    return String.valueOf(object);
	}
	public String toString()
	{
		return "Expression: "+getExpression();
	}
}
