/*------------------------------------------------------------------------------
 * FT / ROSI / DPS
 *------------------------------------------------------------------------------
 * Project     : MLTV2
 * Sub-Project : Portail Web
 *------------------------------------------------------------------------------
 * File        : $Workfile$
 * Author      : Pierre SMEYERS
 * 
 * Description :
 *   The interface of all boolean expressions declared in the portal.
 *------------------------------------------------------------------------------
 * $Log: IBoolExpr.java,v $
 * Revision 1.1.2.2  2006/12/20 09:19:21  mltal
 * Refactorings Bricks (dplacement d'interfaces, changement des composants If, ...)
 *
 * Revision 1.1.2.1  2006/08/25 15:40:42  mltal
 * 1) ANT task for Bricks: generate Mockup, generate XSD, convert JSP 2 Java, generate Javadoc
 * 2) lots of refactoring of Bricks framework (Portal components moved into 'components' package)
 * 3) several new Zac implemented: Credit, Messages, ActuTV
 *
 * Revision 1.1.2.2  2006/08/21 14:47:06  mltal
 * Javadoc and comments.
 *
 */
package com.ebm_ws.infra.bricks.components.base.boolexpr;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.xmlmapping.interfaces.IXmlSubstitutionGroup;
/**
 *   The interface of all boolean expressions declared in the portal.
 */
public interface IBoolExpr extends IXmlSubstitutionGroup
{
	int getDepth();
	/**
	 * Evaluates the boolean expression against the given user context.
	 * @param iRequest The current request.
	 * @return <code>true</code> if the user context matched the expression, <code>false</code> otherwise.
	 */
	boolean eval(HttpServletRequest iRequest);
	/**
	 * Writes the condition in Java manner (inline).
	 * @return A string that represents the whole condition.
	 */
	String toConditionStr();
}
