package com.ebm_ws.infra.bricks.components.base.boolexpr;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Or implements IXmlObject, IBoolExpr
{
	private IBoolExpr[] _xmlcollect_2_unb_expressions;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	public boolean eval(HttpServletRequest iRequest)
	{
		for(int i=0; i<_xmlcollect_2_unb_expressions.length; i++)
		{
			if(_xmlcollect_2_unb_expressions[i].eval(iRequest))
				return true;
		}
		return false;
	}
	public int getDepth()
	{
		int maxDepth = 0;
		for(int i=0; i<_xmlcollect_2_unb_expressions.length; i++)
		{
			int depth = _xmlcollect_2_unb_expressions[i].getDepth();
			if(depth > maxDepth)
				maxDepth = depth;
		}
	    return maxDepth+1;
	}
	public String toConditionStr()
	{
		StringBuffer sb = new StringBuffer("(");
		for(int i=0; i<_xmlcollect_2_unb_expressions.length; i++)
		{
			if(i>0) sb.append(" || ");
			sb.append(_xmlcollect_2_unb_expressions[i].toConditionStr());
		}
		sb.append(')');
		return sb.toString();
	}
}
