package com.ebm_ws.infra.bricks.components.base.boolexpr;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Rule implements IXmlObject, IBoolExpr
{
	private Application _xmlroot;
	private String _xmlattr_req_Name;
	private IBoolExpr _expr;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		if(_xmlattr_req_Name != null)
		{
			_expr = _xmlroot.getRule(_xmlattr_req_Name);
			if(_expr == null)
				iErrors.logMessage(this, "Name", IValidityLogger.ERROR, "No rule with name '"+_xmlattr_req_Name+"' found.");
		}
	}
	public boolean eval(HttpServletRequest iRequest)
	{
		if(_expr == null)
			return true;
		return _expr.eval(iRequest);
	}
	public int getDepth()
	{
		if(_expr == null)
			return 1;
		return _expr.getDepth();
	}
	public String toConditionStr()
	{
		if(_expr == null)
			return "Rule("+_xmlattr_req_Name+")";
		return "Rule("+_xmlattr_req_Name+") --> "+_expr.toConditionStr();
	}
}
