package com.ebm_ws.infra.bricks.components.base.boolexpr;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Test implements IXmlObject, IBoolExpr
{
	private IBinding _xmlcollect_req_binding;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	public boolean eval(HttpServletRequest iRequest)
	{
		Object v = null;
        try
        {
	        v = _xmlcollect_req_binding.invoke(iRequest);
        }
        catch(Exception e)
        {
        	return false;
        }
		if(v == null)
			return false;
		if(v instanceof Boolean)
		{
			return ((Boolean)v).booleanValue();
		}
		if(v instanceof Integer)
		{
			return ((Integer)v).intValue() != 0;
		}
		/*
		if(v.getClass().isArray())
		{
			return Array.getLength(v) == 0;
		}
		if(v instanceof List)
		{
			return ((List)v).size() == 0;
		}
		*/
		return true;
	}
	public String toConditionStr()
	{
		return "Test("+_xmlcollect_req_binding+")";
	}
	public int getDepth()
	{
	    return 1;
	}
}
