package com.ebm_ws.infra.bricks.components.base.boolexpr;

import java.security.Principal;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class UserIs implements IXmlObject, IBoolExpr
{
	// TODO: case sensitivity? partial?
	private String _xmlattr_req_Name;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	public int getDepth()
	{
	    return 1;
	}
	public boolean eval(HttpServletRequest iRequest)
	{
		Principal ppal = iRequest.getUserPrincipal();
		if(ppal == null)
			return false;
		return _xmlattr_req_Name.equals(ppal.getName());
	}
	public String toConditionStr()
	{
		return "UserIs('"+_xmlattr_req_Name+"')";
	}
}
