package com.ebm_ws.infra.bricks.components.base.enums;

import java.text.DateFormat;

import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;

public class DateType implements IEnumeration
{
	public static DateType DateOnly = new DateType();
	public static DateType TimeOnly = new DateType();
	public static DateType DateAndTime = new DateType();
	
	public static DateFormat getInputFormat(ILocaleConfig iLocaleConfig, DateType iType)
	{
		if(iType == DateAndTime)
			return iLocaleConfig.getDateTimeInputFormat();
		if(iType == TimeOnly)
			return iLocaleConfig.getTimeInputFormat();
		return iLocaleConfig.getDateInputFormat();
	}
	public static DateFormat getOutputFormat(ILocaleConfig iLocaleConfig, DateType iType)
	{
		if(iType == DateAndTime)
			return iLocaleConfig.getDateTimeOutputFormat();
		if(iType == TimeOnly)
			return iLocaleConfig.getTimeOutputFormat();
		return iLocaleConfig.getDateOutputFormat();
	}
}
