package com.ebm_ws.infra.bricks.components.base.error;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.interfaces.IFrameContent;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public abstract class ErrorHandler implements IFrameContent, IXmlObject
{
	protected static Log logger = LogFactory.getLog(ErrorHandler.class);
	protected String _xmlattr_opt_FrameName;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO: check frame exists
	}
	public String getFrameName()
	{
	    return _xmlattr_opt_FrameName;
	}
	public static void setNextUrl(HttpServletRequest iRequest, String nextUrl)
	{
		iRequest.setAttribute("javax.servlet.error.next_url", nextUrl);
	}
	public static String getNextUrl(HttpServletRequest iRequest)
	{
		return (String)iRequest.getAttribute("javax.servlet.error.next_url");
	}
	public static Throwable getError(HttpServletRequest iRequest)
	{
//		return (Throwable)iRequest.getSession().getAttribute("_ERROR_");
		return (Throwable)iRequest.getAttribute("javax.servlet.error.exception");
	}
	public abstract String getTitle(HttpServletRequest iRequest) throws Exception;
	
	public void servePage(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		BricksSession session = BricksSession.getSession(iRequest);
		try
		{
			iRequest.setAttribute("_RENDER_PAGE_", this);
			
			// --- 1: pre-render
			session.getApplication().getFrame(getFrameName()).preRender(iRequest);
			
			// --- 2: render
			
			/*
			 * W3C rules:
			 * 
			 * XHTML 1.0 strict:
			 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
			 * <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
			 * 
			 * XHTML 1.0 transitional:
			 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
			 * <html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
			 * 
			 * HTML 4.0.1 strict:
			 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
			 * 
			 * HTML 4.0.1 transitional:
			 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
			 * <html lang="en">
			 * 
			 * XHTML 1.1:
			 * <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
			 * <html lang="en">
			 * 
			 * 
			 * With XHTML, the content type must be "application/xhtml+xml" or "text/xml" (for IE)
			 */
			// --- render response (html)
			iResponse.setContentType("text/html;charset="+session.getLocaleConfig().getCharSet());
//			iResponse.setHeader("Cache-Control", "no-store"); //HTTP 1.1
			iResponse.setHeader("Cache-Control", "no-cache"); //HTTP 1.1
			iResponse.setHeader("Pragma", "no-cache"); //HTTP 1.0
			iResponse.setDateHeader("Expires", 0); //prevents caching at the proxy server
			
			PrintWriter htmlWriter = iResponse.getWriter();
			
			// --- 3: render
			//TODO: other headers
			
			htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
			htmlWriter.print("<html lang=\"");
			htmlWriter.print(session.getLocaleConfig().getLocale().getLanguage());
			htmlWriter.println("\">");
			htmlWriter.println("<head>");
	
			// --- write page title
			htmlWriter.print("<title>");
			htmlWriter.print(HtmlUtils.encode2HTML(this.getTitle(iRequest)));
			htmlWriter.println("</title>");
	
			// --- meta tags
			// html content type
			htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset="+session.getLocaleConfig().getCharSet()+"'>");
			// no cache (for all browsers)
			htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
			htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
			htmlWriter.println("<meta http-equiv='expires' content='0'>");
			// --- les liens relatifs le sont par rapport  l'application
			htmlWriter.print("<base href='");
			htmlWriter.print(iRequest.getScheme());
			htmlWriter.print("://");
			htmlWriter.print(iRequest.getServerName());
			htmlWriter.print(":");
			htmlWriter.print(String.valueOf(iRequest.getServerPort()));
			htmlWriter.print(iRequest.getContextPath());
			htmlWriter.print("/");
			htmlWriter.println("'>");
	
			// --- import stylesheets
			IFrame frame = session.getApplication().getFrame(getFrameName());
			CssStyleSheet[] styleSheets = frame.getStyleSheets();
			if(styleSheets != null)
			{
				for(int i=0; i<styleSheets.length; i++)
				{
					htmlWriter.print("<link rel='stylesheet' type='text/css' href='");
					htmlWriter.print(styleSheets[i].getFile());
					htmlWriter.println("'>");
				}
			}
			
			htmlWriter.println("</head>");
			
			htmlWriter.println("<body>");
			
			// --- render the frame
			frame.render(iRequest, iResponse);
			
			htmlWriter.println("</body>");
			htmlWriter.println("</html>");
			
			htmlWriter.flush();
			htmlWriter.close();
		}
		catch(Throwable t)
		{
			// --- if an error occurs while rendering the error page, display a simple stack
			logger.error("Error while rendering error page:", t);
			iResponse.resetBuffer();
			renderStack(session.getLocaleConfig(), iRequest, iResponse, t);
		}
	}
	private void renderStack(ILocaleConfig iLocaleConfig, HttpServletRequest iRequest, HttpServletResponse iResponse, Throwable t) throws IOException
	{
		iResponse.setContentType("text/html;charset="+iLocaleConfig.getCharSet());
		iResponse.setHeader("Cache-Control", "no-store"); //HTTP 1.1
		iResponse.setHeader("Cache-Control", "no-cache"); //HTTP 1.1
		iResponse.setHeader("Pragma", "no-cache"); //HTTP 1.0
		iResponse.setDateHeader("Expires", 0); //prevents caching at the proxy server

		PrintWriter htmlWriter = iResponse.getWriter();
		
		// --- development context: display the stack in the page
		htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
		htmlWriter.print("<html lang=\"");
		htmlWriter.print(iLocaleConfig.getLocale().getLanguage());
		htmlWriter.println("\">");
		htmlWriter.println("<head>");
		htmlWriter.println("<title>Error</title>");
		htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset="+iLocaleConfig.getCharSet()+"'>");
		// no cache (for all browsers)
		htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
		htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
		//TODO: expires -1 to get reloading the page?
		htmlWriter.println("<meta http-equiv='expires' content='0'>");
		// --- les liens relatifs le sont par rapport  l'application
		htmlWriter.print("<base href='");
		htmlWriter.print(iRequest.getScheme());
		htmlWriter.print("://");
		htmlWriter.print(iRequest.getServerName());
		htmlWriter.print(":");
		htmlWriter.print(String.valueOf(iRequest.getServerPort()));
		htmlWriter.print(iRequest.getContextPath());
		htmlWriter.print("/");
		htmlWriter.println("'>");
		htmlWriter.println("</head>");
		htmlWriter.println("<body bgcolor='#FFFFFF' style='font-family: Verdana; color: #192c8f'>" );
		HtmlUtils.writeStack(htmlWriter, t);
		htmlWriter.println("</body>");
		htmlWriter.println("</html>");
//			htmlWriter.flush(new OutputStreamWriter(iResponse.getOutputStream(), _xmlattr_opt_CharSet));
		htmlWriter.flush();
		htmlWriter.close();
	}
}
