package com.ebm_ws.infra.bricks.components.base.html;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Frame implements IXmlObject, IFrame, IIdentifiable
{
	private String _xmlattr_req_Name;
	private CssStyleSheet[] _xmlnode_1_unb_StyleSheets;
	private IView[] _xmlcollect_1_unb_Views;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Frame_"+_xmlattr_req_Name;
	}
	// --- [-] IIdentifiable implementation

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    // vrifier qu'il y a au moins un page container ?
	}
	public CssStyleSheet[] getStyleSheets()
	{
		return _xmlnode_1_unb_StyleSheets;
	}
	public String getName()
	{
	    return _xmlattr_req_Name;
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
			_xmlcollect_1_unb_Views[i].preRender(iRequest);
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		PrintWriter htmlWriter = iResponse.getWriter();
		// --- open DIV
		htmlWriter.print("<div class=Frame");
		htmlWriter.print(" id='");
		htmlWriter.print(_xmlattr_req_Name);
		htmlWriter.print("'");
		htmlWriter.println(">");
		
		// --- render content
		for(int i=0; i<_xmlcollect_1_unb_Views.length; i++)
			_xmlcollect_1_unb_Views[i].render(iRequest, iResponse);
		
		// --- close DIV
		htmlWriter.println("</div>");
	}
}
