package com.ebm_ws.infra.bricks.components.base.html;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class HTML implements IXmlObject, IView
{
	private int _xmlattr_opt_HeadingIncrement = 0;
	private Code[] _xmlcollect_1_unb_codes;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
//		BricksSession session = BricksSession.getSession(iRequest);
		PrintWriter iWriter = iResponse.getWriter();
		if(_xmlcollect_1_unb_codes == null || _xmlcollect_1_unb_codes.length == 0)
		{
			iWriter.print("No HTML to render Here.");
			return;
		}
		if(_xmlcollect_1_unb_codes.length == 1)
		{
			iWriter.print(_xmlcollect_1_unb_codes[0].getHTML());
			if(_xmlattr_opt_HeadingIncrement != 0)
				HeadingUtils.moveLevel(iRequest, _xmlattr_opt_HeadingIncrement);
			return;
		}
		// --- select code from locale
//		BricksSession session = BricksSession.getSession(iRequest);
		for(int i=0; i<_xmlcollect_1_unb_codes.length; i++)
		{
			if(iResponse.getLocale().getLanguage().equals(_xmlcollect_1_unb_codes[i].getLanguage()))
			{
				iWriter.print(_xmlcollect_1_unb_codes[i].getHTML());
				if(_xmlattr_opt_HeadingIncrement != 0)
					HeadingUtils.moveLevel(iRequest, _xmlattr_opt_HeadingIncrement);
				return;
			}
		}
		// --- matching language not found: use default
		iWriter.print(_xmlcollect_1_unb_codes[0].getHTML());
		if(_xmlattr_opt_HeadingIncrement != 0)
			HeadingUtils.moveLevel(iRequest, _xmlattr_opt_HeadingIncrement);
	}
}
