package com.ebm_ws.infra.bricks.components.base.html;


import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Include implements IXmlObject, IView
{
	private int _xmlattr_opt_HeadingIncrement = 0;
	private String _xmlattr_req_Path;
	private Child[] _xmlnode_0_unb_Children;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- path must be absolute
		if(_xmlattr_req_Path != null && !_xmlattr_req_Path.startsWith("/"))
			iErrors.logMessage(this, "Path", IValidityLogger.ERROR, "Inculde path must be absolute (start with '/').");
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(_xmlnode_0_unb_Children != null)
		{
			for(int i=0; i<_xmlnode_0_unb_Children.length; i++)
				_xmlnode_0_unb_Children[i].getView().preRender(iRequest);
		}
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		RequestDispatcher dispatcher = iRequest.getRequestDispatcher(_xmlattr_req_Path);
		// --- place children in request
		if(_xmlnode_0_unb_Children != null)
		{
			for(int i=0; i<_xmlnode_0_unb_Children.length; i++)
				iRequest.setAttribute("_child_"+_xmlnode_0_unb_Children[i].getID(), _xmlnode_0_unb_Children[i].getView());
		}
		// TODO: develop a taglib to interoperate with Bricks
		/*
		 * Taglib Functions:
		 * - message(key, providerName, args)
		 * - renderChild(name)
		 * 
		 */
		dispatcher.include(iRequest, iResponse);
		
		if(_xmlattr_opt_HeadingIncrement != 0)
			HeadingUtils.moveLevel(iRequest, _xmlattr_opt_HeadingIncrement);
	}
}
