package com.ebm_ws.infra.bricks.components.base.html;

import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class LanguageBar extends BaseBeanProvider implements IView, IXmlObject
{
	private Application _xmlroot;
	private String _xmlattr_opt_CssClass = "LanguageBar";
	private String _xmlattr_opt_LocaleBeanName = "$locale";
	private IBinding _xmlnode_req_Locale;
	private IImage _xmlnode_opt_FlagIcon;
	
	public void checkThisNode(Object validSupport, IValidityLogger iErrors)
	{
		// --- register this as a request handler
		_xmlroot.registerRequestHandler("langbar", this);
		
		// --- check Locale binding
		if(_xmlnode_req_Locale != null && !_xmlnode_req_Locale.hasErrors())
		{
			if(Locale.class != _xmlnode_req_Locale.getType())
				iErrors.logMessage(this, "Locale", IValidityLogger.ERROR, "This binding must return a java.util.Locale value.");
			else if(!_xmlnode_req_Locale.isGetSet())
				iErrors.logMessage(this, "Locale", IValidityLogger.ERROR, "This binding must be settable (to set language when selected).");
		}
	}
	public void preRender(HttpServletRequest request) throws Exception
	{
	}
	public void render(HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		Locale currentLocale = response.getLocale();
		ILocaleConfig[] languages = _xmlroot.getAllLanguages();
		PrintWriter writer = response.getWriter();
		
		UrlBuilder changeLanguageUrl = _xmlroot.createHandlerUrl(request, this, "onChange");
		
		writer.print("<div class='");
		writer.print(_xmlattr_opt_CssClass);
		writer.println("'><ul>");
		for(int i=0; i<languages.length; i++)
		{
			boolean isSelected = currentLocale.getLanguage().equals(languages[i].getLocale().getLanguage());
			request.setAttribute(_xmlattr_opt_LocaleBeanName, languages[i].getLocale());
			String flagImg = _xmlnode_opt_FlagIcon == null ? null : _xmlnode_opt_FlagIcon.getImage(request);
			
			writer.print("<li>");
			if(isSelected)
			{
				writer.print("<span class='selected'>");
			}
			else
			{
				changeLanguageUrl.setParameter("_lang", languages[i].getLocale().getLanguage());
				writer.print("<a href='");
				writer.print(changeLanguageUrl.toUrl(response.getCharacterEncoding(), true));
				writer.print("'>");
			}
			
			String languageName = languages[i].getLocale().getDisplayLanguage(currentLocale);
			if(_xmlnode_opt_FlagIcon != null)
			{
				// --- display flag icon
				writer.print("<img src='");
				writer.write(flagImg);
				writer.print("' title='");
				writer.print(HtmlUtils.encode2HTML(languageName));
				writer.print("' alt='");
				//empty alt is ok				writer.print(HtmlUtils.encode2HTML(languageName, false));
				writer.print("'/>");
			}
			else
			{
				// --- display language name
				writer.print(HtmlUtils.encode2HTML(languageName));
			}
			if(isSelected)
				writer.print("</span>");
			else
				writer.print("</a>");
			writer.println("</li>");
		}
		writer.println("</ul></div>");
	}
	/**
	 * Callbacked method when the user selects a language.
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void onChange(HttpServletRequest iRequest, HttpServletResponse response) throws Exception
	{
		// --- retrieve language and set as current language (in the cookie)
		String lang = iRequest.getParameter("_lang");
		Locale currentLocale = response.getLocale();
		Locale newLocale = new Locale(lang, currentLocale.getCountry());
		
		_xmlnode_req_Locale.setValue(iRequest, newLocale);
		
		// --- then redirect to let Bricks take the new language into account
		BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
		response.sendRedirect(url.toUrl(response.getCharacterEncoding(), false));
	}
	public Class getBeanType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_LocaleBeanName.equals(iName))
		{
			return Locale.class;
		}
		return getParentBeanType(iName);
	}
	public Type getBeanGenericType(String iName) throws UnresolvedBeanError
	{
		if(_xmlattr_opt_LocaleBeanName.equals(iName))
		{
			return Locale.class;
		}
		return getParentBeanGenericType(iName);
	}
	public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception
	{
		if(_xmlattr_opt_LocaleBeanName.equals(iName))
			return iRequest.getAttribute(iName);
		return getParentBeanValue(iRequest, iName);
	}

}
