package com.ebm_ws.infra.bricks.components.base.html;


import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.interfaces.IFrameContent;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class PageContainer implements IView, IXmlObject
{
//	private Application _xmlroot;
	private boolean _xmlattr_opt_RenderTitle = true;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	    // TODO Auto-generated method stub
	    
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		IFrameContent page = (IFrameContent)iRequest.getAttribute("_RENDER_PAGE_");
		page.preRender(iRequest);
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		IFrameContent page = (IFrameContent)iRequest.getAttribute("_RENDER_PAGE_");
//		BricksSession session = BricksSession.getSession(iRequest);
//		IPage page = session.getCurrentPageContext().getPage();
		iWriter.println("<div id='page-container'>");
		// --- render page title?
		if(_xmlattr_opt_RenderTitle)
		{
			// --- H1
			iWriter.print("<h1 class='page-title'>");
			iWriter.print(HtmlUtils.encode2HTML(page.getTitle(iRequest)));
			iWriter.print("</h1>");
			HeadingUtils.setLevel(iRequest, 2);
		}
		// --- have the current page render itself
		page.render(iRequest, iResponse);
		if(_xmlattr_opt_RenderTitle)
			HeadingUtils.setLevel(iRequest, 1);
		iWriter.println("</div>");
	}
}
