package com.ebm_ws.infra.bricks.components.base.html.form;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.RenderingContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public abstract class BaseForm implements IXmlObject, IIdentifiable, IView
{
	protected Application _xmlroot;
	
	protected String _xmlattr_req_ID;
	protected String _xmlattr_opt_CssClass = "Form";
	
	protected IFormItem[] _xmlnode_1_unb_Items;
	
	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Form_"+_xmlattr_req_ID;
	}
	// --- [-] IIdentifiable implementation

	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
		// --- register this component as a request handler
	    if(_xmlroot.registerRequestHandler(getPathID(), this) != null)
        	iErrors.logMessage(this, "ID", IValidityLogger.INFO, "Submit URLs may not be stable on this component. To solve this specify a unique ID in the page.");
	}
	public String getID()
	{
	    return _xmlattr_req_ID;
	}
	
	public abstract boolean isEditable(HttpServletRequest iRequest);
	
	public abstract boolean isEditing(HttpServletRequest iRequest);

	public abstract void renderGlobalErrors(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception;
	
	public abstract void renderButtons(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception;
	
	public FormSubmitContext getSubmitContext(HttpServletRequest iRequest)
	{
	    return (FormSubmitContext)iRequest.getAttribute("$submitctx."+getID());
	}
	protected void setSubmitContext(HttpServletRequest iRequest, FormSubmitContext iSubmitContext)
	{
	    iRequest.setAttribute("$submitctx."+getID(), iSubmitContext);
	}
	public FormRenderingContext getRenderingContext(HttpServletRequest iRequest)
	{
		return (FormRenderingContext)iRequest.getAttribute("$renderctx."+getID());
	}

	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		FormRenderingContext context = new FormRenderingContext();
		context.editable = isEditable(iRequest);
		context.editMode = context.editable && isEditing(iRequest);
		context.form = this;
		context.submitContext = getSubmitContext(iRequest);
		
		iRequest.setAttribute("$renderctx."+getID(), context);
		
		// --- TODO: callback OnReset in view mode (ViewEdit form)
		for(int i=0; i<_xmlnode_1_unb_Items.length; i++)
			_xmlnode_1_unb_Items[i].preRender(iRequest);

		RenderingContext.get(iRequest).put(this, "ctx", context);
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		FormRenderingContext context = (FormRenderingContext)RenderingContext.get(iRequest).get(this, "ctx");
		iRequest.setAttribute("#formctx", context);
		
		
		// --- render
		PrintWriter iWriter = iResponse.getWriter();
		
		if(context.editMode)
			HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
		
		iWriter.println("<div class='"+_xmlattr_opt_CssClass+"'>");
		if(context.editMode)
		{
			iWriter.print("<form name='"+getID()+"' method='post' action='");
//			iWriter.print(_xmlroot.createHandlerUrl(iRequest, this, "submit").toUrl(iRequest.getCharacterEncoding(), true));
			iWriter.print(BricksUrlBuilder.copyFromRequest(iRequest, true).toUrl(iRequest.getCharacterEncoding(), true));
			iWriter.println("'>");
			iWriter.print("<input type='hidden' name='");
			iWriter.print(_xmlroot.getHandlerParamName());
			iWriter.print("'");
			iWriter.print(" value='");
			iWriter.print(_xmlroot.getHandlerParamValue(this, "submit"));
			iWriter.print("'");
			iWriter.println("/>");
		}
		
		// --- render errors
		renderGlobalErrors(iRequest, iResponse, context);
		
		// --- render form items
		iWriter.println("<div class=Fields>");
		for(int i=0; i<_xmlnode_1_unb_Items.length; i++)
		{
			context.oddField = i%2 == 0;
			_xmlnode_1_unb_Items[i].render(iRequest, iResponse);
		}
		iWriter.println("</div>");
		
		// --- render buttons
		renderButtons(iRequest, iResponse, context);
		
		if(context.editMode)
			iWriter.println("</form>");
		
		iWriter.println("</div>");
		
		// --- push script to focus the first editable field
		if(context.editMode && iRequest.getAttribute("_FORM_FOCUS_FIRST_") == null)
		{
			iWriter.println("<script language='javascript' type='text/javascript'>");
			iWriter.println("Form_focusFirstInput('"+getID()+"');");
			iWriter.println("</script>");
			
			iRequest.setAttribute("_FORM_FOCUS_FIRST_", Boolean.TRUE);
		}
	}
}
