package com.ebm_ws.infra.bricks.components.base.html.form;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;

public class EditForm extends BaseForm
{
	private IMessage _xmlnode_opt_SubmitButtonLabel;
	private IBinding _xmlnode_opt_OnValidate;
	private IAction _xmlnode_opt_OnSubmit;
	private IBinding[] _xmlnode_0_unb_OnResetChange;
	
	// ceci n'est pas pour le view and edit: cancel retourne au mode dition !
	private IAction _xmlnode_opt_OnCancel;
	
	@Override
	public boolean isEditable(HttpServletRequest iRequest)
	{
	    return true;
	}
	@Override
	public boolean isEditing(HttpServletRequest iRequest)
	{
	    return true;
	}
	public void submit(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(!isEditable(iRequest))
			// --- forbidden
			//TODO
			throw new Exception("Forbidden access");
		
		/*
		// dump request
		Enumeration hNames = iRequest.getParameterNames();
		if(hNames != null)
		{
			System.out.println("Submit Request:");
			while(hNames.hasMoreElements())
			{
				String name = (String)hNames.nextElement();
				System.out.println("--> ["+name+"] : ["+iRequest.getParameter(name)+"]");
			}
		}
		*/
		// --- instantiate submit context
		FormSubmitContext submitCtx = new FormSubmitContext(iRequest.getParameter("action"));
		setSubmitContext(iRequest, submitCtx);
		
		// --- have each form item handle the submission
		for(int ikey=0; ikey<_xmlnode_1_unb_Items.length; ikey++)
			_xmlnode_1_unb_Items[ikey].submit(iRequest, submitCtx);
		
		if(!submitCtx.isSubmitAction())
			// --- dynamic reload: do not validate
			return;
		
		// --- trigger global validation
		if(_xmlnode_opt_OnValidate != null)
		{
			try
			{
				_xmlnode_opt_OnValidate.invoke(iRequest);
			}
			catch(ValidationErrors e)
			{
				submitCtx.getValidationErrors().addErrors(e);
			}
		}
		
		if(submitCtx.getValidationErrors().hasErrors())
			// --- form has errors: (re)display form with errors
			return;
		
		if(_xmlnode_opt_OnSubmit == null)
			// --- this is a filter form (no submission)
			return;
		
		// --- validation passed: submit form
		_xmlnode_opt_OnSubmit.invoke(iRequest, iResponse);
	}
	@Override
	public void renderGlobalErrors(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		FormSubmitContext submitCtx = getSubmitContext(iRequest);
		if(submitCtx != null && submitCtx.isSubmitAction())
		{
			// --- affichage du form aprs un submit avec des erreurs
			List<IValidationMessage> errors = submitCtx.getValidationErrors().getGlobalErrors();
			if(errors != null && errors.size() > 0)
			{
				PrintWriter iWriter = iResponse.getWriter();
				iWriter.println("<ul class=errors>");
				for(int i=0; i<errors.size(); i++)
				{
					iWriter.print("<li>");
					iWriter.print(HtmlUtils.encode2HTML(errors.get(i).getMessage(iRequest)));
					iWriter.println("</li>");
				}
				iWriter.println("</ul>");
			}
		}
	}
	@Override
	public void renderButtons(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		
		// --- render action input
		iWriter.println("<input type='hidden' name='action' value='submit'/>");
		
		int nbButtons = 0;
		if(_xmlnode_opt_OnSubmit != null)
			nbButtons++;
		if(_xmlnode_opt_OnCancel != null)
			nbButtons++;
		if(_xmlnode_0_unb_OnResetChange != null && _xmlnode_0_unb_OnResetChange.length > 0)
			nbButtons++;
		
		if(nbButtons == 0)
			// --- no button
			return;

//		BricksSession session = BricksSession.getSession(iRequest);
		ResourceBundle msgs = BricksMessages.getBundle(iResponse.getLocale());
		iWriter.print("<div class='Buttons'>");
		iWriter.print("<ul>");

		// --- submit button
		if(_xmlnode_opt_OnSubmit != null)
		{
			String submitLabel = null;
			if(_xmlnode_opt_SubmitButtonLabel != null)
				submitLabel = _xmlnode_opt_SubmitButtonLabel.getMessage(iRequest);
			else
				submitLabel = msgs.getString("button.submit");
			iWriter.print("<li>");
			iWriter.print("<input type='submit' value=\"");
			iWriter.print(HtmlUtils.encode2HTML(submitLabel));
			iWriter.print("\">");
			iWriter.println("</li>");
		}
		
		// --- reset button
		if(_xmlnode_0_unb_OnResetChange != null && _xmlnode_0_unb_OnResetChange.length > 0)
		{
			String resetUrl = _xmlroot.createHandlerUrl(iRequest, this, "reset").toUrl(iRequest.getCharacterEncoding(), true);
			iWriter.print("<li>");
			iWriter.print("<a href='");
			iWriter.print(resetUrl);
			iWriter.print("'>");
			iWriter.print(msgs.getString("button.reset"));
			iWriter.print("</a>");
			iWriter.println("</li>");
		}
		// --- cancel button
		if(_xmlnode_opt_OnCancel != null)
		{
			String cancelUrl = _xmlnode_opt_OnCancel.getURL(iRequest, true);
			iWriter.print("<li>");
			iWriter.print("<a href='");
			iWriter.print(cancelUrl);
			iWriter.print("'>");
			iWriter.print(msgs.getString("button.cancel"));
			iWriter.print("</a>");
			iWriter.println("</li>");
		}
		iWriter.print("</ul>");
		iWriter.println("</div>");
	}
	public void reset(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(_xmlnode_0_unb_OnResetChange != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnResetChange.length; i++)
				_xmlnode_0_unb_OnResetChange[i].invoke(iRequest);
		}
	}

}
