package com.ebm_ws.infra.bricks.components.base.html.form;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class Section implements IXmlObject, IFormItem
{
	private BaseForm _xmlancestor_Form;
	private IMessage _xmlnode_req_Title;
	private IBoolExpr _xmlnode_opt_Visible;
	private IFormItem[] _xmlcollect_1_unb_Items;
	
	public void checkThisNode(Object iValidSupport, IValidityLogger iErrors)
	{
	}
	public boolean isVisible(HttpServletRequest iRequest)
	{
		return _xmlnode_opt_Visible == null || _xmlnode_opt_Visible.eval(iRequest);
	}
	protected BaseForm getForm()
	{
		return _xmlancestor_Form;
	}
	public void submit(HttpServletRequest iRequest, FormSubmitContext iSubmitContext) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		for(int i=0; i<_xmlcollect_1_unb_Items.length; i++)
			_xmlcollect_1_unb_Items[i].submit(iRequest, iSubmitContext);
	}
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		for(int i=0; i<_xmlcollect_1_unb_Items.length; i++)
			_xmlcollect_1_unb_Items[i].preRender(iRequest);
	}
	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		FormRenderingContext iContext = getForm().getRenderingContext(iRequest);
		
		PrintWriter iWriter = iResponse.getWriter();
		iWriter.println("<fieldset>");
		iWriter.print("<legend>");
		/* Non: interdit au niveau HTML 4.01
		 * TODO: trouver solution alternative
		// --- put an heading element
		int hLevel = HeadingUtils.getLevel(iRequest);
		HeadingUtils.incrLevel(iRequest);
		iWriter.print("<h");
		iWriter.print(String.valueOf(hLevel));
		iWriter.print(">");
		*/
		iWriter.print(HtmlUtils.encode2HTML(_xmlnode_req_Title.getMessage(iRequest)));
		/*
		iWriter.print("</h");
		iWriter.print(String.valueOf(hLevel));
		iWriter.print(">");
		*/
		iWriter.println("</legend>");
		for(int i=0; i<_xmlcollect_1_unb_Items.length; i++)
		{
			iContext.oddField = i%2 == 0;
			_xmlcollect_1_unb_Items[i].render(iRequest, iResponse);
		}
		// --- decrement heading level
		HeadingUtils.decrLevel(iRequest);
		iWriter.println("</fieldset>");
	}
}
