package com.ebm_ws.infra.bricks.components.base.html.form;

import java.io.PrintWriter;
import java.util.List;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;

public class ViewEditForm extends BaseForm
{
	private boolean _xmlattr_opt_ShowResetButton = true;
	private IMessage _xmlnode_opt_SubmitButtonLabel;
	private IBoolExpr _xmlnode_opt_Editable;
	private IMenuItem[] _xmlnode_0_unb_AddButtons;
	private IBinding[] _xmlnode_0_unb_OnReload;
	private IBinding _xmlnode_opt_OnValidate;
	private IAction _xmlnode_req_OnSubmit;
	private IBinding[] _xmlnode_1_unb_OnResetChange;
	
	public boolean isEditable(HttpServletRequest iRequest)
	{
		if(_xmlnode_opt_Editable == null)
			return true;
		return _xmlnode_opt_Editable.eval(iRequest);
	}
	@Override
	public boolean isEditing(HttpServletRequest iRequest)
	{
		boolean editRequired = "edit".equals(iRequest.getParameter(getID()+".mode"));
		return editRequired && isEditable(iRequest);
	}
	public void submit(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(!isEditable(iRequest))
			// --- forbidden
			//TODO
			throw new Exception("Forbidden access");
		
		/*
		// dump request
		Enumeration hNames = iRequest.getParameterNames();
		if(hNames != null)
		{
			System.out.println("Submit Request:");
			while(hNames.hasMoreElements())
			{
				String name = (String)hNames.nextElement();
				System.out.println("--> ["+name+"] : ["+iRequest.getParameter(name)+"]");
			}
		}
		*/

		// --- form has changed
		BricksSession session = BricksSession.getSession(iRequest);
		session.getCurrentPageContext().setAttribute("form."+getID()+".changed", Boolean.TRUE);
		
		// --- instantiate submit context
		FormSubmitContext submitCtx = new FormSubmitContext(iRequest.getParameter("action"));
		setSubmitContext(iRequest, submitCtx);
		
		// --- have each form item handle the submission
		for(int ikey=0; ikey<_xmlnode_1_unb_Items.length; ikey++)
			_xmlnode_1_unb_Items[ikey].submit(iRequest, submitCtx);
		
		if(!submitCtx.isSubmitAction())
			// --- dynamic reload: do not validate
			return;
		
		// --- trigger global validation
		if(_xmlnode_opt_OnValidate != null)
		{
			try
			{
				_xmlnode_opt_OnValidate.invoke(iRequest);
			}
			catch(ValidationErrors e)
			{
				submitCtx.getValidationErrors().addErrors(e);
			}
		}
		
		if(submitCtx.getValidationErrors().hasErrors())
			// --- form has errors: (re)display form with errors
			return;
		
		// --- valiation passed: submit form
		_xmlnode_req_OnSubmit.invoke(iRequest, iResponse);
	}
	@Override
	public void renderGlobalErrors(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		FormSubmitContext submitCtx = getSubmitContext(iRequest);
		if(submitCtx != null && submitCtx.isSubmitAction())
		{
			// --- affichage du form aprs un submit avec des erreurs
			List<IValidationMessage> errors = submitCtx.getValidationErrors().getGlobalErrors();
			if(errors != null && errors.size() > 0)
			{
				PrintWriter iWriter = iResponse.getWriter();
				iWriter.println("<ul class=errors>");
				for(int i=0; i<errors.size(); i++)
				{
					iWriter.print("<li>");
					iWriter.print(HtmlUtils.encode2HTML(errors.get(i).getMessage(iRequest)));
					iWriter.println("</li>");
				}
				iWriter.println("</ul>");
			}
		}
	}
	@Override
	public void renderButtons(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		PrintWriter iWriter = iResponse.getWriter();
		
		// --- render action input
		iWriter.println("<input type='hidden' name='action' value='submit'/>");

//		BricksSession session = BricksSession.getSession(iRequest);
		ResourceBundle msgs = BricksMessages.getBundle(iResponse.getLocale());
		iWriter.print("<div class='Buttons'>");
		iWriter.print("<ul>");

		if(iContext.editMode)
		{
			// --- edit mode
			// --- submit button
			String submitLabel = null;
			if(_xmlnode_opt_SubmitButtonLabel != null)
				submitLabel = _xmlnode_opt_SubmitButtonLabel.getMessage(iRequest);
			else
				submitLabel = msgs.getString("button.save");
			iWriter.print("<li>");
			iWriter.print("<input type='submit' value=\"");
			iWriter.print(HtmlUtils.encode2HTML(submitLabel));
			iWriter.print("\">");
			iWriter.println("</li>");
			
			// --- reset button
			if(_xmlattr_opt_ShowResetButton)
			{
				String resetUrl = _xmlroot.createHandlerUrl(iRequest, this, "reset").toUrl(iRequest.getCharacterEncoding(), true);
				iWriter.print("<li>");
				iWriter.print("<a href='");
				iWriter.print(resetUrl);
				iWriter.print("'>");
				iWriter.print(msgs.getString("button.reset"));
				iWriter.print("</a>");
				iWriter.println("</li>");
			}
			// --- cancel button
			String cancelUrl = BricksUrlBuilder.copyFromRequest(iRequest, true).setParameter(getID()+".mode", "view").toUrl(iRequest.getCharacterEncoding(), true);
			iWriter.print("<li>");
			iWriter.print("<a href='");
			iWriter.print(cancelUrl);
			iWriter.print("'>");
			iWriter.print(msgs.getString("button.cancel"));
			iWriter.print("</a>");
			iWriter.println("</li>");
			
			// --- additional buttons (disabled)
			if(_xmlnode_0_unb_AddButtons != null)
			{
				ILinkHrefRenderer disabledRenderer = new ILinkHrefRenderer()
				{
					public boolean isEnabled(HttpServletRequest request)
					{return false;}
					public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception {}
				};
				for(int i=0; i<_xmlnode_0_unb_AddButtons.length; i++)
					_xmlnode_0_unb_AddButtons[i].render(iRequest, iResponse, disabledRenderer);
			}
		}
		else
		{
			// --- view mode
			if(isEditable(iRequest))
			{
				String editUrl = BricksUrlBuilder.copyFromRequest(iRequest, true).setParameter(getID()+".mode", "edit").toUrl(iRequest.getCharacterEncoding(), true);
				iWriter.print("<li>");
				iWriter.print("<a href='");
				iWriter.print(editUrl);
				iWriter.print("'>");
				iWriter.print(msgs.getString("button.edit"));
				iWriter.print("</a>");
				iWriter.println("</li>");
			}
			else
			{
				// --- display disabled button
				iWriter.print("<li>");
				iWriter.print("<span class='disabled'>");
				iWriter.print(msgs.getString("button.edit"));
				iWriter.print("</span>");
				iWriter.println("</li>");
			}
			
			// --- reload button
			if(_xmlnode_0_unb_OnReload != null && _xmlnode_0_unb_OnReload.length > 0)
			{
				String reloadUrl = _xmlroot.createHandlerUrl(iRequest, this, "reload").toUrl(iRequest.getCharacterEncoding(), true);
				iWriter.print("<li>");
				iWriter.print("<a href='");
				iWriter.print(reloadUrl);
				iWriter.print("'>");
				iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.reload")));
				iWriter.print("</a>");
				iWriter.println("</li>");
			}
			
			// --- additional buttons
			if(_xmlnode_0_unb_AddButtons != null)
			{
				for(int i=0; i<_xmlnode_0_unb_AddButtons.length; i++)
					_xmlnode_0_unb_AddButtons[i].render(iRequest, iResponse, null);
			}
			
		}
		iWriter.print("</ul>");
		iWriter.println("</div>");
	}
	public void reset(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(_xmlnode_1_unb_OnResetChange != null)
		{
			for(int i=0; i<_xmlnode_1_unb_OnResetChange.length; i++)
				_xmlnode_1_unb_OnResetChange[i].invoke(iRequest);

			BricksSession session = BricksSession.getSession(iRequest);
			session.getCurrentPageContext().removeAttribute("form."+getID()+".changed");
		}
	}
	public void reload(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(_xmlnode_0_unb_OnReload != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnReload.length; i++)
				_xmlnode_0_unb_OnReload[i].invoke(iRequest);

			BricksSession session = BricksSession.getSession(iRequest);
			session.getCurrentPageContext().removeAttribute("form."+getID()+".changed");
		}
	}
	@Override
	public void preRender(HttpServletRequest iRequest) throws Exception
	{
	    super.preRender(iRequest);
	    
	    if(!getRenderingContext(iRequest).editMode)
	    {
	    	// --- view mode: reset changes (if need be)
			BricksSession session = BricksSession.getSession(iRequest);
			if(Boolean.TRUE.equals(session.getCurrentPageContext().getAttribute("form."+getID()+".changed")))
			{
				// --- form has changed: reset
				for(int i=0; i<_xmlnode_1_unb_OnResetChange.length; i++)
					_xmlnode_1_unb_OnResetChange[i].invoke(iRequest);

				session.getCurrentPageContext().removeAttribute("form."+getID()+".changed");
			}
	    }
	}

}
