package com.ebm_ws.infra.bricks.components.base.html.form;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;

public class ViewForm extends BaseForm
{
	private IBinding[] _xmlnode_0_unb_OnReload;
	private IMenuItem[] _xmlnode_0_unb_AddButtons;

	public void reload(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(_xmlnode_0_unb_OnReload != null)
		{
			for(int i=0; i<_xmlnode_0_unb_OnReload.length; i++)
				_xmlnode_0_unb_OnReload[i].invoke(iRequest);
		}
	}
	@Override
	public boolean isEditable(HttpServletRequest iRequest)
	{
	    return false;
	}
	@Override
	public boolean isEditing(HttpServletRequest iRequest)
	{
	    return false;
	}
	@Override
	public void renderButtons(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
		boolean hasButtons = false;
		if(_xmlnode_0_unb_OnReload != null && _xmlnode_0_unb_OnReload.length > 0)
		{
			hasButtons = true;
		}
		else
		{
			if(_xmlnode_0_unb_AddButtons != null)
			{
				hasButtons = true;
				/* TODO: count buttons
				for(int i=0; i<_xmlnode_0_unb_AddButtons.length; i++)
				{
					if(_xmlnode_0_unb_AddButtons[i].isVisible(iRequest))
					{
						hasButtons = true;
						break;
					}
				}
				*/
			}
		}
		
		if(hasButtons)
		{
			PrintWriter iWriter = iResponse.getWriter();
			iWriter.print("<div class='Buttons'>");
			iWriter.print("<ul>");
			if(_xmlnode_0_unb_OnReload != null && _xmlnode_0_unb_OnReload.length > 0)
			{
//				BricksSession session =  BricksSession.getSession(iRequest);
				String reloadUrl = _xmlroot.createHandlerUrl(iRequest, this, "reload").toUrl(iRequest.getCharacterEncoding(), true);
				iWriter.print("<li>");
				iWriter.print("<a href='");
				iWriter.print(reloadUrl);
				iWriter.print("'>");
				iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.reload")));
				iWriter.print("</a>");
				iWriter.println("</li>");
			}
			if(_xmlnode_0_unb_AddButtons != null)
			{
				for(int i=0; i<_xmlnode_0_unb_AddButtons.length; i++)
				{
					_xmlnode_0_unb_AddButtons[i].render(iRequest, iResponse, null);
				}
			}

			iWriter.print("</ul>");
			iWriter.println("</div>");
		}
	}
	@Override
	public void renderGlobalErrors(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception
	{
	}
}
