package com.ebm_ws.infra.bricks.components.base.html.form.field;

import java.io.PrintWriter;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.IFormItem;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public abstract class BaseEditableField implements IXmlObject, IFormItem, IIdentifiable
{
	private BaseForm _xmlancestor_Form;
	protected IMessage _xmlnode_req_Label;
	private IBoolExpr _xmlnode_opt_Visible;
	protected IBoolExpr _xmlnode_opt_Editable;
	protected IBinding _xmlnode_req_Bind;
	private IMenuItem[] _xmlnode_0_unb_FieldButtons;

	// --- [+] IIdentifiable implementation
	private IIdentifiable _xmlancestor_id;
	public String getPathID()
	{
		if(_xmlancestor_id == null)
			return getElementID();
		return _xmlancestor_id.getPathID()+"."+getElementID();
	}
	private String getElementID()
	{
		return "Field_"+_xmlnode_req_Bind.getID();
	}
	// --- [-] IIdentifiable implementation
	
	protected BaseForm getForm()
	{
		return _xmlancestor_Form;
	}
	
	public boolean isVisible(HttpServletRequest iRequest)
	{
		return _xmlnode_opt_Visible == null || _xmlnode_opt_Visible.eval(iRequest);
	}
	public boolean isEditable(HttpServletRequest iRequest)
	{
		if(!isVisible(iRequest))
			return false;
		return _xmlnode_opt_Editable == null || _xmlnode_opt_Editable.eval(iRequest);
	}
	public abstract String getFieldName();
	public String getFieldId()
	{
		return getForm().getID()+"_"+getFieldName();
	}
	
	protected abstract void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception;
	
	protected abstract boolean isMandatory(HttpServletRequest iRequest);

	public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception
	{
		if(!isVisible(iRequest))
			return;
		
		FormRenderingContext renderingCtx = getForm().getRenderingContext(iRequest);
		boolean mandatory = isMandatory(iRequest);
		
		PrintWriter iWriter = iResponse.getWriter();
		iWriter.print("<div class='field");
		if(renderingCtx.isOddField())
		    iWriter.print(" odd");
		else
            iWriter.print(" even");
		if(mandatory)
            iWriter.print(" mandatory");
        iWriter.println("'>");
		// --- label
		iWriter.print("<label class=field");
		if(renderingCtx.isEditMode() && this.isEditable(iRequest))
		{
			iWriter.print(" for='");
			iWriter.print(getFieldId());
			iWriter.print("'");
		}
		iWriter.print(">");
		iWriter.print(HtmlUtils.encode2HTML(_xmlnode_req_Label.getMessage(iRequest)));
		iWriter.println("</label>");
		
		// --- input
		iWriter.print("<div class=input>");
		renderInput(iRequest, iResponse, renderingCtx);
		iWriter.println("</div>");
		
		// --- mark mandatory fields ?
		
		// --- field buttons
		// --- only displayed in edition mode ? (otherwise do we have to submit?)
		if(_xmlnode_0_unb_FieldButtons != null && _xmlnode_0_unb_FieldButtons.length > 0)
		{
			ILinkHrefRenderer linkRenderer = null;
			if(renderingCtx.isEditMode())
			{
				// --- field buttons are disabled
				linkRenderer = new ILinkHrefRenderer()
				{
					public boolean isEnabled(HttpServletRequest request)
					{return false;}
					public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception {}
				};
			}
			
			iWriter.println("<ul class=fieldbuttons>");
			for(int i=0; i<_xmlnode_0_unb_FieldButtons.length; i++)
				_xmlnode_0_unb_FieldButtons[i].render(iRequest, iResponse, linkRenderer);
			iWriter.println("</ul>");
		}
		
		// --- error(s)
		if(renderingCtx.getSubmitContext() != null && renderingCtx.getSubmitContext().isSubmitAction())
		{
			List<IValidationMessage> errors = renderingCtx.getSubmitContext().getValidationErrors().getItemErrors(getFieldName());
			if(errors != null && errors.size() > 0)
			{
				iWriter.println("<ul class=errors>");
				for(int i=0; i<errors.size(); i++)
				{
					iWriter.print("<li>");
					iWriter.print(HtmlUtils.encode2HTML(errors.get(i).getMessage(iRequest)));
					iWriter.println("</li>");
				}
				iWriter.println("</ul>");
			}
		}
		
		iWriter.println("</div>");
	}

}
