package com.ebm_ws.infra.bricks.components.base.html.form.field;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.validation.IValidator;
import com.ebm_ws.infra.bricks.components.base.validation.Mandatory;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;

public abstract class BaseSingleValueField extends BaseEditableField
{
	protected IValidator[] _xmlnode_0_unb_Validators;
	
	public abstract Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder);
	
	public String getFieldName()
	{
		return _xmlnode_req_Bind.getID();
	}
	
    public boolean isMandatory(HttpServletRequest request) 
    {
        boolean result = false;
        if (_xmlnode_0_unb_Validators != null) {
            for (IValidator validator : _xmlnode_0_unb_Validators) {
                if (validator instanceof Mandatory) {
                    result = true;
                }
            }
        }
        return result;
    }

	@Override
	public boolean isEditable(HttpServletRequest iRequest)
	{
		return _xmlnode_req_Bind.isGetSet() && super.isEditable(iRequest);
	}
	public void submit(HttpServletRequest iRequest, FormSubmitContext iSubmitContext) throws Exception
	{
		if(!isEditable(iRequest))
			return;
		
		// --- transform
		Object value = getValueFromRequest(iRequest, iSubmitContext.getValidationErrors());
		if(iSubmitContext.getValidationErrors().hasItemErrors(getFieldName()))
			// --- do not set the value to the UI bean
			return;
		
		// --- set
		_xmlnode_req_Bind.setValue(iRequest, value);
		
		// --- validate
		if(_xmlnode_0_unb_Validators != null)
		{
			for(int i=0; i<_xmlnode_0_unb_Validators.length; i++)
			{
				_xmlnode_0_unb_Validators[i].checkValidity(getFieldName(), value, iSubmitContext.getValidationErrors());
			}
		}
	}
}
